/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileExtraction {
    private final ZipFile _zipFile;
    private final File _targetDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileExtraction(File file, File targetDir) throws IOException {
        this._targetDir = targetDir;
        this._zipFile = new ZipFile(file);
        try {
            this.extractEntries();
        }
        finally {
            this._zipFile.close();
        }
    }

    private void extractEntries() throws IOException {
        Enumeration<? extends ZipEntry> entries = this._zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            this.extractEntry(entry);
        }
    }

    private void extractEntry(ZipEntry entry) throws IOException {
        if (entry.isDirectory()) {
            this.targetPathFor(entry).mkdirs();
            return;
        }
        this.extractFileEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFileEntry(ZipEntry entry) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(this.targetPathFor(entry));
        try {
            InputStream is = this._zipFile.getInputStream(entry);
            try {
                this.copy(is, fos);
            }
            finally {
                is.close();
            }
        }
        finally {
            fos.close();
        }
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[65536];
        int bytesRead = 0;
        while (-1 != (bytesRead = is.read(buffer))) {
            os.write(buffer, 0, bytesRead);
        }
    }

    private File targetPathFor(ZipEntry entry) {
        File targetPath = new File(this._targetDir, entry.getName());
        targetPath.getParentFile().mkdirs();
        return targetPath;
    }
}

