/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.ant;

import com.db4o.instrumentation.ant.AntClassEditFactory;
import com.db4o.instrumentation.ant.AntFileSetPathRoot;
import com.db4o.instrumentation.classfilter.CompositeOrClassFilter;
import com.db4o.instrumentation.classfilter.JarFileClassFilter;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.core.CompositeBloatClassEdit;
import com.db4o.instrumentation.core.NullClassEdit;
import com.db4o.instrumentation.file.InstrumentationClassSource;
import com.db4o.instrumentation.main.Db4oFileInstrumentor;
import com.db4o.instrumentation.main.Db4oJarEnhancer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db4oFileEnhancerAntTask
extends Task {
    private final List<FileSet> _sources = new ArrayList<FileSet>();
    private File _targetDir;
    private final List<Path> _classPath = new ArrayList<Path>();
    private final List<AntClassEditFactory> _editFactories = new ArrayList<AntClassEditFactory>();
    private final List<FileSet> _jars = new ArrayList<FileSet>();
    private File _jarTargetDir;
    private boolean _verbose = false;

    public void add(AntClassEditFactory editFactory) {
        this._editFactories.add(editFactory);
    }

    public void addSources(FileSet fileSet) {
        this._sources.add(fileSet);
    }

    public void addJars(FileSet fileSet) {
        this._jars.add(fileSet);
    }

    public void setClassTargetDir(File targetDir) {
        this._targetDir = targetDir;
    }

    public void setJarTargetdir(File targetDir) {
        this._jarTargetDir = targetDir;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public void addClasspath(Path path) {
        this._classPath.add(path);
    }

    public void execute() {
        try {
            FileSet[] sourceArr = this._sources.toArray(new FileSet[this._sources.size()]);
            AntFileSetPathRoot root = new AntFileSetPathRoot(sourceArr);
            ClassFilter filter = this.collectClassFilters(root);
            BloatClassEdit clazzEdit = this.collectClassEdits(filter);
            String[] classPath = this.collectClassPath();
            this.enhanceClassFiles(root, clazzEdit, classPath);
            this.enhanceJars(clazzEdit, classPath);
        }
        catch (Exception exc) {
            throw new BuildException((Throwable)exc);
        }
    }

    private String[] collectClassPath() throws Exception {
        final ArrayList<String> paths = new ArrayList<String>();
        for (Path path : this._classPath) {
            String[] curPaths;
            for (String curPath : curPaths = path.list()) {
                paths.add(curPath);
            }
        }
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource resource) throws Exception {
                paths.add(resource.getFile().getCanonicalPath());
            }
        });
        for (FileSet fileSet : this._sources) {
            paths.add(fileSet.getDir().getCanonicalPath());
        }
        return paths.toArray(new String[paths.size()]);
    }

    private void enhanceClassFiles(AntFileSetPathRoot root, BloatClassEdit clazzEdit, String[] classPath) throws Exception {
        this.logClassFiles(root);
        new Db4oFileInstrumentor(clazzEdit).enhance(root, this._targetDir, classPath);
    }

    private void enhanceJars(BloatClassEdit clazzEdit, final String[] classPath) throws Exception {
        final Db4oJarEnhancer jarEnhancer = new Db4oJarEnhancer(clazzEdit);
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource resource) throws Exception {
                File targetJarFile = new File(Db4oFileEnhancerAntTask.this._jarTargetDir, resource.getFile().getName());
                Db4oFileEnhancerAntTask.this.verboseLog("Enhancing jar: " + targetJarFile.getAbsolutePath());
                jarEnhancer.enhance(resource.getFile(), targetJarFile, classPath);
            }
        });
    }

    private ClassFilter collectClassFilters(AntFileSetPathRoot root) throws Exception {
        final ArrayList<AntFileSetPathRoot> filters = new ArrayList<AntFileSetPathRoot>();
        filters.add(root);
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource resource) throws IOException {
                JarFile jarFile = new JarFile(resource.getFile());
                filters.add(new JarFileClassFilter(jarFile));
            }
        });
        CompositeOrClassFilter filter = new CompositeOrClassFilter(filters.toArray(new ClassFilter[filters.size()]));
        return filter;
    }

    private void forEachResource(List<FileSet> fileSets, FileResourceBlock collectFiltersBlock) throws Exception {
        for (FileSet fileSet : fileSets) {
            for (FileResource fileResource : fileSet) {
                collectFiltersBlock.process(fileResource);
            }
        }
    }

    private BloatClassEdit collectClassEdits(ClassFilter classFilter) {
        BloatClassEdit clazzEdit = null;
        switch (this._editFactories.size()) {
            case 0: {
                clazzEdit = new NullClassEdit();
                break;
            }
            case 1: {
                clazzEdit = this._editFactories.get(0).createEdit(classFilter);
                break;
            }
            default: {
                ArrayList<BloatClassEdit> classEdits = new ArrayList<BloatClassEdit>(this._editFactories.size());
                for (AntClassEditFactory curFactory : this._editFactories) {
                    classEdits.add(curFactory.createEdit(classFilter));
                }
                clazzEdit = new CompositeBloatClassEdit(classEdits.toArray(new BloatClassEdit[classEdits.size()]), true);
            }
        }
        return clazzEdit;
    }

    private void verboseLog(String msg) {
        if (this._verbose) {
            this.log(msg, 2);
        }
    }

    private void logClassFiles(AntFileSetPathRoot root) throws IOException {
        this.verboseLog("Enhancing class files.");
        this.verboseLog("Target folder: " + this._targetDir.getAbsolutePath());
        this.verboseLog("Root folders:");
        for (String rootStr : root.rootDirs()) {
            this.verboseLog(new File(rootStr).getAbsolutePath());
        }
        this.verboseLog("Files:");
        Iterator<InstrumentationClassSource> fileSetIter = root.iterator();
        while (fileSetIter.hasNext()) {
            this.verboseLog(fileSetIter.next().toString());
        }
    }

    private static interface FileResourceBlock {
        public void process(FileResource var1) throws Exception;
    }
}

