/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4Iterator;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.foundation.Sequence4;
import com.db4o.types.Unversioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection4<T>
implements Sequence4<T>,
Iterable4<T>,
DeepClone,
Unversioned {
    private List4<T> _first;
    private List4<T> _last;
    private int _size;
    private int _version;

    public Collection4() {
    }

    public Collection4(int initialLength) {
    }

    public Collection4(T[] elements) {
        this.addAll(elements);
    }

    public Collection4(Iterable4<T> other) {
        this.addAll(other);
    }

    public Collection4(Iterator4<T> iterator) {
        this.addAll(iterator);
    }

    public T singleElement() {
        if (this.size() != 1) {
            throw new IllegalStateException();
        }
        return this._first._element;
    }

    @Override
    public final boolean add(T element) {
        this.doAdd(element);
        this.changed();
        return true;
    }

    public final void prepend(T element) {
        this.doPrepend(element);
        this.changed();
    }

    private void doPrepend(T element) {
        if (this._first == null) {
            this.doAdd(element);
        } else {
            this._first = new List4<T>(this._first, element);
            ++this._size;
        }
    }

    private void doAdd(T element) {
        if (this._last == null) {
            this._first = new List4<T>(element);
            this._last = this._first;
        } else {
            this._last._next = new List4<T>(element);
            this._last = this._last._next;
        }
        ++this._size;
    }

    public final void addAll(T[] elements) {
        this.assertNotNull(elements);
        for (int i = 0; i < elements.length; ++i) {
            this.add(elements[i]);
        }
    }

    @Override
    public final void addAll(Iterable4<T> other) {
        this.assertNotNull(other);
        this.addAll(other.iterator());
    }

    @Override
    public final void addAll(Iterator4<T> iterator) {
        this.assertNotNull(iterator);
        while (iterator.moveNext()) {
            this.add(iterator.current());
        }
    }

    @Override
    public final void clear() {
        this._first = null;
        this._last = null;
        this._size = 0;
        this.changed();
    }

    @Override
    public final boolean contains(T element) {
        return this.find(element) != null;
    }

    @Override
    public boolean containsAll(Iterable4<T> iter) {
        return this.containsAll(iter.iterator());
    }

    @Override
    public boolean containsAll(Iterator4<T> iter) {
        this.assertNotNull(iter);
        while (iter.moveNext()) {
            if (this.contains(iter.current())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsByIdentity(T element) {
        Iterator4<T> i = this.internalIterator();
        while (i.moveNext()) {
            T current = i.current();
            if (current != element) continue;
            return true;
        }
        return false;
    }

    private List4<T> find(T obj) {
        List4<T> current = this._first;
        while (current != null) {
            if (current.holds(obj)) {
                return current;
            }
            current = current._next;
        }
        return null;
    }

    private List4<T> findByIdentity(T obj) {
        List4<T> current = this._first;
        while (current != null) {
            if (current._element == obj) {
                return current;
            }
            current = current._next;
        }
        return null;
    }

    public final T get(T element) {
        List4<T> holder = this.find(element);
        return holder == null ? null : (T)holder._element;
    }

    @Override
    public Object deepClone(Object newParent) {
        Collection4<Object> col = new Collection4<Object>();
        T element = null;
        Iterator4<T> i = this.internalIterator();
        while (i.moveNext()) {
            element = i.current();
            if (element instanceof DeepClone) {
                col.add(((DeepClone)element).deepClone(newParent));
                continue;
            }
            col.add(element);
        }
        return col;
    }

    public final T ensure(T element) {
        List4<T> list = this.find(element);
        if (list == null) {
            this.add(element);
            return element;
        }
        return list._element;
    }

    @Override
    public final Iterator4<T> iterator() {
        return this._first == null ? Iterators.EMPTY_ITERATOR : new Collection4Iterator(this, this._first);
    }

    @Override
    public T get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        List4<T> cur = this._first;
        while (index > 0 && cur != null) {
            cur = cur._next;
            --index;
        }
        if (cur == null) {
            throw new IllegalArgumentException();
        }
        return cur._element;
    }

    public void removeAll(Iterable4<T> iterable) {
        this.removeAll(iterable.iterator());
    }

    public void removeAll(Iterator4<T> iterator) {
        while (iterator.moveNext()) {
            this.remove(iterator.current());
        }
    }

    @Override
    public boolean remove(T a_object) {
        List4<T> previous = null;
        List4<T> current = this._first;
        while (current != null) {
            if (current.holds(a_object)) {
                --this._size;
                this.adjustOnRemoval(previous, current);
                this.changed();
                return true;
            }
            previous = current;
            current = current._next;
        }
        return false;
    }

    public void replace(T oldObject, T newObject) {
        List4<T> list = this.find(oldObject);
        if (list != null) {
            list._element = newObject;
        }
    }

    public void replaceByIdentity(T oldObject, T newObject) {
        List4<T> list = this.findByIdentity(oldObject);
        if (list != null) {
            list._element = newObject;
        }
    }

    private void adjustOnRemoval(List4<T> previous, List4<T> removed) {
        if (removed == this._first) {
            this._first = removed._next;
        } else {
            previous._next = removed._next;
        }
        if (removed == this._last) {
            this._last = previous;
        }
    }

    @Override
    public final int size() {
        return this._size;
    }

    public int indexOf(T obj) {
        int index = 0;
        List4<T> current = this._first;
        while (current != null) {
            if (current.holds(obj)) {
                return index;
            }
            ++index;
            current = current._next;
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public final T[] toArray(T[] array) {
        int j = 0;
        Iterator4<T> i = this.internalIterator();
        while (i.moveNext()) {
            array[j++] = i.current();
        }
        return array;
    }

    @Override
    public final Object[] toArray() {
        int j = 0;
        Object[] array = new Object[this.size()];
        Iterator4<T> i = this.internalIterator();
        while (i.moveNext()) {
            array[j++] = i.current();
        }
        return array;
    }

    public String toString() {
        return Iterators.toString(this.internalIterator());
    }

    private void changed() {
        ++this._version;
    }

    int version() {
        return this._version;
    }

    private void assertNotNull(Object element) {
        if (element == null) {
            throw new ArgumentNullException();
        }
    }

    private Iterator4<T> internalIterator() {
        return new Iterator4Impl(this._first);
    }
}

