/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.drs.db4o;

import com.db4o.Internal4;
import com.db4o.ObjectSet;
import com.db4o.ext.Db4oDatabase;
import com.db4o.foundation.Arrays4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.query.Query;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationRecord
implements Internal4 {
    public Db4oDatabase _youngerPeer;
    public Db4oDatabase _olderPeer;
    public long _version;
    public long[] _concurrentTimestamps;

    public ReplicationRecord() {
    }

    public ReplicationRecord(Db4oDatabase younger, Db4oDatabase older) {
        this._youngerPeer = younger;
        this._olderPeer = older;
    }

    public void setVersion(long version) {
        this._version = version;
    }

    public void store(ObjectContainerBase container) {
        this.store(container.checkTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Transaction trans) {
        ObjectContainerBase container = trans.container();
        container.showInternalClasses(true);
        try {
            container.storeAfterReplication(trans, this, container.updateDepthProvider().forDepth(Integer.MAX_VALUE), false);
        }
        finally {
            container.showInternalClasses(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplicationRecord beginReplication(Transaction transA, Transaction transB) {
        ObjectContainerBase peerA = transA.container();
        ObjectContainerBase peerB = transB.container();
        Db4oDatabase dbA = peerA.identity();
        Db4oDatabase dbB = peerB.identity();
        dbB.bind(transA);
        dbA.bind(transB);
        Db4oDatabase younger = null;
        Db4oDatabase older = null;
        if (dbA.isOlderThan(dbB)) {
            younger = dbB;
            older = dbA;
        } else {
            younger = dbA;
            older = dbB;
        }
        ReplicationRecord rrA = ReplicationRecord.queryForReplicationRecord(peerA, transA, younger, older);
        ReplicationRecord rrB = ReplicationRecord.queryForReplicationRecord(peerB, transB, younger, older);
        if (rrA == null) {
            if (rrB == null) {
                return new ReplicationRecord(younger, older);
            }
            rrB.store(peerA);
            return rrB;
        }
        if (rrB == null) {
            rrA.store(peerB);
            return rrA;
        }
        if (rrA != rrB) {
            peerB.showInternalClasses(true);
            try {
                int id = peerB.getID(transB, rrB);
                peerB.bind(transB, rrA, id);
            }
            finally {
                peerB.showInternalClasses(false);
            }
        }
        return rrA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplicationRecord queryForReplicationRecord(ObjectContainerBase container, Transaction trans, Db4oDatabase younger, Db4oDatabase older) {
        container.showInternalClasses(true);
        try {
            Query q = container.query(trans);
            q.constrain(ReplicationRecord.class);
            q.descend("_youngerPeer").constrain(younger).identity();
            q.descend("_olderPeer").constrain(older).identity();
            ObjectSet objectSet = q.execute();
            if (objectSet.hasNext()) {
                ReplicationRecord replicationRecord = (ReplicationRecord)objectSet.next();
                container.activate(replicationRecord, Integer.MAX_VALUE);
                ReplicationRecord replicationRecord2 = replicationRecord;
                return replicationRecord2;
            }
            ReplicationRecord replicationRecord = null;
            return replicationRecord;
        }
        finally {
            container.showInternalClasses(false);
        }
    }

    public void concurrentTimestamps(List<Long> concurrentTimestamps) {
        this._concurrentTimestamps = Arrays4.toLongArray(concurrentTimestamps);
    }

    public long[] concurrentTimestamps() {
        return this._concurrentTimestamps;
    }
}

