/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.defragment.FirstPassCommand;
import com.db4o.defragment.PassCommand;
import com.db4o.defragment.SecondPassCommand;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.mapping.IdSource;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.Storage;
import java.io.IOException;

public class Defragment {
    public static void defrag(String origPath) throws IOException {
        Defragment.defrag(new DefragmentConfig(origPath), new NullListener());
    }

    public static void defrag(String origPath, String backupPath) throws IOException {
        Defragment.defrag(new DefragmentConfig(origPath, backupPath), new NullListener());
    }

    public static void defrag(DefragmentConfig config) throws IOException {
        Defragment.defrag(config, new NullListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defrag(DefragmentConfig config, DefragmentListener listener) throws IOException {
        Storage storage = config.db4oConfig().storage();
        Defragment.ensureFileExists(storage, config.origPath());
        Storage backupStorage = config.backupStorage();
        if (backupStorage.exists(config.backupPath()) && !config.forceBackupDelete()) {
            throw new IOException("Could not use '" + config.backupPath() + "' as backup path - file exists.");
        }
        backupStorage.delete(config.backupPath());
        Defragment.moveToBackup(config);
        if (config.fileNeedsUpgrade()) {
            Defragment.upgradeFile(config);
        }
        DefragmentServicesImpl services = new DefragmentServicesImpl(config, listener);
        try {
            Defragment.firstPass(services, config);
            services.commitIds();
            Defragment.secondPass(services, config);
            services.commitIds();
            Defragment.defragUnindexed(services);
            services.commitIds();
            services.defragIdToTimestampBtree();
            services.replaceClassMetadataRepository();
        }
        catch (CorruptionException exc) {
            exc.printStackTrace();
        }
        finally {
            services.close();
        }
    }

    private static void moveToBackup(DefragmentConfig config) throws IOException {
        Storage origStorage = config.db4oConfig().storage();
        if (origStorage == config.backupStorage()) {
            origStorage.rename(config.origPath(), config.backupPath());
            return;
        }
        Defragment.copyBin(origStorage, config.backupStorage(), config.origPath(), config.backupPath());
        origStorage.delete(config.origPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyBin(Storage sourceStorage, Storage targetStorage, String sourcePath, String targetPath) throws IOException {
        Bin origBin = sourceStorage.open(new BinConfiguration(sourcePath, true, 0L, true));
        try {
            Bin backupBin = targetStorage.open(new BinConfiguration(targetPath, true, origBin.length(), false));
            try {
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                int pos = 0;
                while ((bytesRead = origBin.read(pos, buffer, buffer.length)) >= 0) {
                    backupBin.write(pos, buffer, bytesRead);
                    pos += bytesRead;
                }
            }
            finally {
                Defragment.syncAndClose(backupBin);
            }
        }
        finally {
            Defragment.syncAndClose(origBin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncAndClose(Bin bin) {
        try {
            bin.sync();
        }
        finally {
            bin.close();
        }
    }

    private static void ensureFileExists(Storage storage, String origPath) throws IOException {
        if (!storage.exists(origPath)) {
            throw new IOException("Source database file '" + origPath + "' does not exist.");
        }
    }

    private static void upgradeFile(DefragmentConfig config) throws IOException {
        Defragment.copyBin(config.backupStorage(), config.backupStorage(), config.backupPath(), config.tempPath());
        Configuration db4oConfig = (Configuration)((Config4Impl)config.db4oConfig()).deepClone(null);
        db4oConfig.storage(config.backupStorage());
        db4oConfig.allowVersionUpdates(true);
        ObjectContainer db = Db4o.openFile(db4oConfig, config.tempPath());
        db.close();
    }

    private static void defragUnindexed(DefragmentServicesImpl services) {
        IdSource unindexedIDs = services.unindexedIDs();
        while (unindexedIDs.hasMoreIds()) {
            int origID = unindexedIDs.nextId();
            DefragmentContextImpl.processCopy(services, origID, new SlotCopyHandler(){

                public void processCopy(DefragmentContextImpl context) {
                    ClassMetadata.defragObject(context);
                }
            });
        }
    }

    private static void firstPass(DefragmentServicesImpl context, DefragmentConfig config) throws CorruptionException, IOException {
        Defragment.pass(context, config, new FirstPassCommand());
    }

    private static void secondPass(DefragmentServicesImpl context, DefragmentConfig config) throws CorruptionException, IOException {
        Defragment.pass(context, config, new SecondPassCommand(config.objectCommitFrequency()));
    }

    private static void pass(DefragmentServicesImpl context, DefragmentConfig config, PassCommand command) throws CorruptionException, IOException {
        command.processClassCollection(context);
        StoredClass[] classes = context.storedClasses(DefragmentServicesImpl.SOURCEDB);
        for (int classIdx = 0; classIdx < classes.length; ++classIdx) {
            ClassMetadata classMetadata = (ClassMetadata)classes[classIdx];
            if (!config.storedClassFilter().accept(classMetadata)) continue;
            Defragment.processClass(context, classMetadata, command);
            command.flush(context);
            if (config.objectCommitFrequency() <= 0) continue;
            context.targetCommit();
        }
        BTree uuidIndex = context.sourceUuidIndex();
        if (uuidIndex != null) {
            command.processBTree(context, uuidIndex);
        }
        command.flush(context);
        context.targetCommit();
    }

    private static void processClass(DefragmentServicesImpl context, ClassMetadata curClass, PassCommand command) throws CorruptionException, IOException {
        Defragment.processClassIndex(context, curClass, command);
        if (!Defragment.parentHasIndex(curClass)) {
            Defragment.processObjectsForClass(context, curClass, command);
        }
        Defragment.processClassAndFieldIndices(context, curClass, command);
    }

    private static boolean parentHasIndex(ClassMetadata curClass) {
        for (ClassMetadata parentClass = curClass.getAncestor(); parentClass != null; parentClass = parentClass.getAncestor()) {
            if (!parentClass.hasClassIndex()) continue;
            return true;
        }
        return false;
    }

    private static void processObjectsForClass(final DefragmentServicesImpl context, final ClassMetadata curClass, final PassCommand command) {
        context.traverseAll(curClass, new Visitor4(){

            public void visit(Object obj) {
                int id = (Integer)obj;
                try {
                    command.processObjectSlot(context, curClass, id);
                }
                catch (CorruptionException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void processClassAndFieldIndices(DefragmentServicesImpl context, ClassMetadata curClass, PassCommand command) throws CorruptionException, IOException {
        int sourceClassIndexID = 0;
        int targetClassIndexID = 0;
        if (curClass.hasClassIndex()) {
            sourceClassIndexID = curClass.index().id();
            targetClassIndexID = context.mappedID(sourceClassIndexID, -1);
        }
        command.processClass(context, curClass, curClass.getID(), targetClassIndexID);
    }

    private static void processClassIndex(DefragmentServicesImpl context, ClassMetadata curClass, PassCommand command) throws CorruptionException, IOException {
        if (curClass.hasClassIndex()) {
            BTreeClassIndexStrategy indexStrategy = (BTreeClassIndexStrategy)curClass.index();
            BTree btree = indexStrategy.btree();
            command.processBTree(context, btree);
        }
    }

    static class NullListener
    implements DefragmentListener {
        NullListener() {
        }

        public void notifyDefragmentInfo(DefragmentInfo info) {
        }
    }
}

