/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.objectexchange;

import com.db4o.cs.internal.objectexchange.ReferenceCollector;
import com.db4o.cs.internal.objectexchange.SlotAccessor;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Pair;
import com.db4o.internal.slots.Slot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlotCollector {
    private SlotAccessor _slotAccessor;
    private ReferenceCollector _referenceCollector;
    private int _depth;
    private Map<Integer, Collection4> referenceCache = new HashMap<Integer, Collection4>();

    public SlotCollector(int depth, ReferenceCollector collector, SlotAccessor accessor) {
        if (depth < 1) {
            throw new IllegalArgumentException();
        }
        this._depth = depth;
        this._slotAccessor = accessor;
        this._referenceCollector = collector;
    }

    public List<Pair<Integer, Slot>> collect(Iterator4<Integer> roots) {
        return this.childSlotsFor(roots);
    }

    private List<Pair<Integer, Slot>> childSlotsFor(Iterator4<Integer> slots) {
        ArrayList<Pair<Integer, Slot>> result = new ArrayList<Pair<Integer, Slot>>();
        this.collectSlots(slots, result, this._depth);
        return result;
    }

    private void collectSlots(Iterator4<Integer> ids, ArrayList<Pair<Integer, Slot>> result, int currentDepth) {
        while (ids.moveNext()) {
            int id = ids.current();
            if (!this.containsSlotFor(result, id)) {
                result.add(this.idSlotPairFor(id));
            }
            if (currentDepth <= 1) continue;
            Iterator4 childIds = this.collectChildIdsFor(id);
            this.collectSlots(childIds, result, currentDepth - 1);
        }
    }

    private boolean containsSlotFor(ArrayList<Pair<Integer, Slot>> result, int id) {
        for (Pair<Integer, Slot> pair : result) {
            if ((Integer)pair.first != id) continue;
            return true;
        }
        return false;
    }

    private Iterator4 collectChildIdsFor(int id) {
        Collection4<Integer> references = this.referenceCache.get(id);
        if (null == references) {
            references = new Collection4<Integer>(this._referenceCollector.referencesFrom(id));
            this.referenceCache.put(id, references);
        }
        return references.iterator();
    }

    private Pair<Integer, Slot> idSlotPairFor(int id) {
        return Pair.of(id, this._slotAccessor.currentSlotOfID(id));
    }
}

