/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.objectexchange;

import com.db4o.cs.caching.ClientSlotCache;
import com.db4o.cs.internal.ClientTransaction;
import com.db4o.cs.internal.objectexchange.FixedSizeIntIterator4Base;
import com.db4o.foundation.FixedSizeIntIterator4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Pair;
import com.db4o.internal.ByteArrayBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheContributingObjectReader {
    private final ByteArrayBuffer _reader;
    private final ClientTransaction _transaction;
    private final ClientSlotCache _slotCache;

    public CacheContributingObjectReader(ClientTransaction transaction, ClientSlotCache slotCache, ByteArrayBuffer reader) {
        this._reader = reader;
        this._transaction = transaction;
        this._slotCache = slotCache;
    }

    public Iterator4<Pair<Integer, ByteArrayBuffer>> buffers() {
        final Map<Integer, Pair<Integer, ByteArrayBuffer>> slots = this.readSlots();
        return Iterators.map(this.readRootIds(), (Function4)new Function4<Integer, Pair<Integer, ByteArrayBuffer>>(){

            @Override
            public Pair<Integer, ByteArrayBuffer> apply(Integer arg) {
                return (Pair)slots.get(arg);
            }
        });
    }

    public FixedSizeIntIterator4 iterator() {
        this.contributeSlotsToCache();
        return this.readRootIds();
    }

    private FixedSizeIntIterator4 readRootIds() {
        int size = this._reader.readInt();
        return new FixedSizeIntIterator4Base(size){

            protected int nextInt() {
                return CacheContributingObjectReader.this._reader.readInt();
            }
        };
    }

    private void contributeSlotsToCache() {
        int size = this._reader.readInt();
        for (int i = 0; i < size; ++i) {
            this.readNextSlot();
        }
    }

    private Map<Integer, Pair<Integer, ByteArrayBuffer>> readSlots() {
        HashMap<Integer, Pair<Integer, ByteArrayBuffer>> slots = new HashMap<Integer, Pair<Integer, ByteArrayBuffer>>();
        int size = this._reader.readInt();
        for (int i = 0; i < size; ++i) {
            Pair<Integer, ByteArrayBuffer> slot = this.readNextSlot();
            slots.put((Integer)slot.first, slot);
        }
        return slots;
    }

    private Pair<Integer, ByteArrayBuffer> readNextSlot() {
        int id = this._reader.readInt();
        int length = this._reader.readInt();
        if (length == 0) {
            return Pair.of(id, null);
        }
        ByteArrayBuffer slot = this.readNextSlot(length);
        this.contributeToCache(id, slot);
        return Pair.of(id, slot);
    }

    private void contributeToCache(int id, ByteArrayBuffer slot) {
        this._slotCache.add(this._transaction, id, slot);
    }

    private ByteArrayBuffer readNextSlot(int length) {
        ByteArrayBuffer slot = this._reader.readPayloadReader(this._reader.offset(), length);
        this._reader.skip(length);
        return slot;
    }
}

