/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.messages;

import com.db4o.config.QueryEvaluationMode;
import com.db4o.cs.internal.LazyClientObjectSetStub;
import com.db4o.cs.internal.ServerMessageDispatcher;
import com.db4o.cs.internal.messages.MsgD;
import com.db4o.cs.internal.messages.MsgObject;
import com.db4o.cs.internal.objectexchange.ObjectExchangeConfiguration;
import com.db4o.cs.internal.objectexchange.ObjectExchangeStrategyFactory;
import com.db4o.foundation.IntIterator4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.query.result.AbstractQueryResult;

public abstract class MsgQuery
extends MsgObject {
    private static int nextID;

    protected final MsgD writeQueryResult(AbstractQueryResult queryResult, QueryEvaluationMode evaluationMode, ObjectExchangeConfiguration config) {
        if (evaluationMode == QueryEvaluationMode.IMMEDIATE) {
            return this.writeImmediateQueryResult(queryResult, config);
        }
        return this.writeLazyQueryResult(queryResult, config);
    }

    private MsgD writeLazyQueryResult(AbstractQueryResult queryResult, ObjectExchangeConfiguration config) {
        int queryResultId = MsgQuery.generateID();
        int maxCount = this.config().prefetchObjectCount();
        IntIterator4 idIterator = queryResult.iterateIDs();
        MsgD message = this.buildQueryResultMessage(queryResultId, idIterator, maxCount, config);
        ServerMessageDispatcher serverThread = this.serverMessageDispatcher();
        serverThread.mapQueryResultToID(new LazyClientObjectSetStub(queryResult, idIterator), queryResultId);
        return message;
    }

    private MsgD writeImmediateQueryResult(AbstractQueryResult queryResult, ObjectExchangeConfiguration config) {
        IntIterator4 idIterator = queryResult.iterateIDs();
        MsgD message = this.buildQueryResultMessage(0, idIterator, queryResult.size(), config);
        return message;
    }

    private MsgD buildQueryResultMessage(int queryResultId, IntIterator4 ids, int maxCount, ObjectExchangeConfiguration config) {
        ByteArrayBuffer payload = ObjectExchangeStrategyFactory.forConfig(config).marshall((LocalTransaction)this.transaction(), ids, maxCount);
        MsgD message = QUERY_RESULT.getWriterForLength(this.transaction(), 4 + payload.length());
        StatefulBuffer writer = message.payLoad();
        writer.writeInt(queryResultId);
        writer.writeBytes(payload._buffer);
        return message;
    }

    private static synchronized int generateID() {
        if (++nextID < 0) {
            nextID = 1;
        }
        return nextID;
    }

    protected AbstractQueryResult newQueryResult(QueryEvaluationMode mode) {
        return this.container().newQueryResult(this.transaction(), mode);
    }
}

