/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.foundation.Socket4;
import com.db4o.cs.foundation.Socket4Factory;
import com.db4o.ext.Db4oIOException;
import java.io.IOException;

public class Socket4Adapter {
    private final Socket4 _delegate;

    public Socket4Adapter(Socket4 delegate) {
        this._delegate = delegate;
    }

    public Socket4Adapter(Socket4Factory socketFactory, String hostName, int port) {
        try {
            this._delegate = socketFactory.createSocket(hostName, port);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void close() throws Db4oIOException {
        try {
            this._delegate.close();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void flush() throws Db4oIOException {
        try {
            this._delegate.flush();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public boolean isConnected() {
        return this._delegate.isConnected();
    }

    public Socket4Adapter openParalellSocket() throws Db4oIOException {
        try {
            return new Socket4Adapter(this._delegate.openParallelSocket());
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public int read(byte[] buffer, int bufferOffset, int byteCount) throws Db4oIOException {
        try {
            return this._delegate.read(buffer, bufferOffset, byteCount);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void setSoTimeout(int timeout) {
        this._delegate.setSoTimeout(timeout);
    }

    public void write(byte[] bytes, int offset, int count) throws Db4oIOException {
        try {
            this._delegate.write(bytes, offset, count);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public void write(byte[] bytes) throws Db4oIOException {
        try {
            this._delegate.write(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    public String toString() {
        return this._delegate.toString();
    }
}

