/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.Db4oEmbedded;
import com.db4o.cs.internal.ShutdownMode;
import com.db4o.foundation.Entry4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerSession;
import com.db4o.internal.Transaction;

public class ClientTransactionPool {
    private final Hashtable4 _transaction2Container;
    private final Hashtable4 _fileName2Container;
    private final LocalObjectContainer _mainContainer;
    private boolean _closed;

    public ClientTransactionPool(LocalObjectContainer mainContainer) {
        ContainerCount mainEntry = new ContainerCount(mainContainer, 1);
        this._transaction2Container = new Hashtable4();
        this._fileName2Container = new Hashtable4();
        this._fileName2Container.put(mainContainer.fileName(), (Object)mainEntry);
        this._mainContainer = mainContainer;
    }

    public Transaction acquireMain() {
        return this.acquire(this._mainContainer.fileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction acquire(String fileName) {
        Object object = this._mainContainer.lock();
        synchronized (object) {
            ContainerCount entry = (ContainerCount)this._fileName2Container.get(fileName);
            if (entry == null) {
                LocalObjectContainer container = (LocalObjectContainer)Db4oEmbedded.openFile(Db4oEmbedded.newConfiguration(), fileName);
                container.configImpl().setMessageRecipient(this._mainContainer.configImpl().messageRecipient());
                entry = new ContainerCount(container);
                this._fileName2Container.put(fileName, (Object)entry);
            }
            Transaction transaction = entry.newTransaction();
            ObjectContainerSession objectContainerSession = new ObjectContainerSession(entry.container(), transaction);
            transaction.setOutSideRepresentation(objectContainerSession);
            this._transaction2Container.put(transaction, (Object)entry);
            return transaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ShutdownMode mode, Transaction transaction, boolean rollbackOnClose) {
        Object object = this._mainContainer.lock();
        synchronized (object) {
            ContainerCount entry = (ContainerCount)this._transaction2Container.get(transaction);
            entry.container().closeTransaction(transaction, false, mode.isFatal() ? false : rollbackOnClose);
            this._transaction2Container.remove(transaction);
            entry.release();
            if (entry.isEmpty()) {
                this._fileName2Container.remove(entry.fileName());
                try {
                    entry.close(mode);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public void close() {
        this.close(ShutdownMode.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ShutdownMode mode) {
        Object object = this._mainContainer.lock();
        synchronized (object) {
            Iterator4 entryIter = this._fileName2Container.iterator();
            while (entryIter.moveNext()) {
                Entry4 hashEntry = (Entry4)entryIter.current();
                ContainerCount containerCount = (ContainerCount)hashEntry.value();
                try {
                    containerCount.close(mode);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            this._closed = true;
        }
    }

    public int openTransactionCount() {
        return this.isClosed() ? 0 : this._transaction2Container.size();
    }

    public int openFileCount() {
        return this.isClosed() ? 0 : this._fileName2Container.size();
    }

    public boolean isClosed() {
        return this._closed || this._mainContainer.isClosed();
    }

    public static class ContainerCount {
        private LocalObjectContainer _container;
        private int _count;

        public ContainerCount(LocalObjectContainer container) {
            this(container, 0);
        }

        public LocalObjectContainer container() {
            return this._container;
        }

        public ContainerCount(LocalObjectContainer container, int count) {
            this._container = container;
            this._count = count;
        }

        public boolean isEmpty() {
            return this._count <= 0;
        }

        public Transaction newTransaction() {
            ++this._count;
            return this._container.newUserTransaction();
        }

        public void release() {
            if (this._count == 0) {
                throw new IllegalStateException();
            }
            --this._count;
        }

        public String fileName() {
            return this._container.fileName();
        }

        public void close(ShutdownMode mode) {
            if (!mode.isFatal()) {
                this._container.close();
                this._container = null;
                return;
            }
            this._container.fatalShutdown(((ShutdownMode.FatalMode)mode).exc());
        }

        public int hashCode() {
            return this.fileName().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ContainerCount other = (ContainerCount)obj;
            return this.fileName().equals(other.fileName());
        }
    }
}

