/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.BlobTransport;
import com.db4o.DTrace;
import com.db4o.ObjectContainer;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.cs.caching.ClientSlotCache;
import com.db4o.cs.config.ClientConfiguration;
import com.db4o.cs.internal.BlobProcessor;
import com.db4o.cs.internal.ClassInfo;
import com.db4o.cs.internal.ClassInfoHelper;
import com.db4o.cs.internal.ClientAsynchronousMessageProcessor;
import com.db4o.cs.internal.ClientHeartbeat;
import com.db4o.cs.internal.ClientMessageDispatcher;
import com.db4o.cs.internal.ClientMessageDispatcherImpl;
import com.db4o.cs.internal.ClientQueryResult;
import com.db4o.cs.internal.ClientTransaction;
import com.db4o.cs.internal.LazyClientQueryResult;
import com.db4o.cs.internal.Socket4Adapter;
import com.db4o.cs.internal.caching.ClientSlotCacheImpl;
import com.db4o.cs.internal.caching.NullClientSlotCache;
import com.db4o.cs.internal.config.ClientConfigurationImpl;
import com.db4o.cs.internal.config.Db4oClientServerLegacyConfigurationBridge;
import com.db4o.cs.internal.events.ClientEventRegistryImpl;
import com.db4o.cs.internal.messages.ClientSideMessage;
import com.db4o.cs.internal.messages.MDeleteBlobFile;
import com.db4o.cs.internal.messages.MError;
import com.db4o.cs.internal.messages.MReadBytes;
import com.db4o.cs.internal.messages.MReadMultipleObjects;
import com.db4o.cs.internal.messages.MRuntimeException;
import com.db4o.cs.internal.messages.MUserMessage;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.cs.internal.messages.MsgBlob;
import com.db4o.cs.internal.messages.MsgD;
import com.db4o.cs.internal.messages.MsgObject;
import com.db4o.cs.internal.objectexchange.CacheContributingObjectReader;
import com.db4o.cs.internal.objectexchange.ObjectExchangeConfiguration;
import com.db4o.cs.internal.objectexchange.ObjectExchangeStrategy;
import com.db4o.cs.internal.objectexchange.ObjectExchangeStrategyFactory;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.ExtClient;
import com.db4o.ext.InvalidPasswordException;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.BlockingQueueStoppedException;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.FixedSizeIntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.NotSupportedException;
import com.db4o.foundation.Pair;
import com.db4o.internal.ArrayType;
import com.db4o.internal.BlobImpl;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.ExternalObjectContainer;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerSession;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Serializer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.encoding.UnicodeStringIO;
import com.db4o.internal.events.EventRegistryImpl;
import com.db4o.internal.qlin.QLinRoot;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.processor.QQueryBase;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.references.ReferenceSystem;
import com.db4o.internal.slots.Pointer4;
import com.db4o.io.Storage;
import com.db4o.qlin.QLin;
import com.db4o.reflect.ReflectClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientObjectContainer
extends ExternalObjectContainer
implements ExtClient,
BlobTransport,
ClientMessageDispatcher {
    final Object _blobLock = new Object();
    private BlobProcessor _blobTask;
    private Socket4Adapter _socket;
    private BlockingQueue _synchronousMessageQueue = new BlockingQueue();
    private BlockingQueue _asynchronousMessageQueue = new BlockingQueue();
    private final String _password;
    int[] _prefetchedIDs;
    ClientMessageDispatcher _messageDispatcher;
    ClientAsynchronousMessageProcessor _asynchronousMessageProcessor;
    int remainingIDs;
    private String switchedToFile;
    private boolean _singleThreaded;
    private final String _userName;
    private Db4oDatabase i_db;
    protected boolean _doFinalize = true;
    private int _blockSize = 1;
    private Collection4 _batchedMessages = new Collection4();
    private int _batchedQueueLength = 4;
    private boolean _login;
    private final ClientHeartbeat _heartbeat;
    private final ClassInfoHelper _classInfoHelper;
    private ClientSlotCache _clientSlotCache;
    private int _serverSideID = 0;
    private MessageListener _messageListener = new MessageListener(){

        public void onMessage(Msg msg) {
        }
    };
    private boolean _bypassSlotCache = false;

    public ClientObjectContainer(ClientConfiguration config, Socket4Adapter socket, String user, String password, boolean login) {
        this((ClientConfigurationImpl)config, socket, user, password, login);
    }

    public ClientObjectContainer(ClientConfigurationImpl config, Socket4Adapter socket, String user, String password, boolean login) {
        super(Db4oClientServerLegacyConfigurationBridge.asLegacy(config));
        this._userName = user;
        this._password = password;
        this._login = login;
        this._heartbeat = new ClientHeartbeat(this);
        this._classInfoHelper = new ClassInfoHelper(Db4oClientServerLegacyConfigurationBridge.asLegacy(config));
        this.setAndConfigSocket(socket);
        this.open();
        config.applyConfigurationItems(this);
    }

    private void setAndConfigSocket(Socket4Adapter socket) {
        this._socket = socket;
        this._socket.setSoTimeout(this._config.timeoutClientSocket());
    }

    @Override
    protected final void openImpl() {
        this.initializeClassMetadataRepository();
        this.initalizeWeakReferenceSupport();
        this.initalizeClientSlotCache();
        this._singleThreaded = this.configImpl().singleThreadedClient();
        if (this._login) {
            this.loginToServer(this._socket);
        }
        if (!this._singleThreaded) {
            this.startDispatcherThread(this._socket, this._userName);
        }
        this.logMsg(36, this.toString());
        this.startHeartBeat();
        this.readThis();
    }

    private final void initalizeClientSlotCache() {
        this.configImpl().prefetchSettingsChanged().addListener(new EventListener4<EventArgs>(){

            @Override
            public void onEvent(Event4<EventArgs> e, EventArgs args) {
                ClientObjectContainer.this.initalizeClientSlotCache();
            }
        });
        if (this.configImpl().prefetchSlotCacheSize() > 0) {
            this._clientSlotCache = new ClientSlotCacheImpl(this);
            return;
        }
        this._clientSlotCache = new NullClientSlotCache();
    }

    private void startHeartBeat() {
        this._heartbeat.start();
    }

    private void startDispatcherThread(Socket4Adapter socket, String user) {
        if (!this._singleThreaded) {
            this.startAsynchronousMessageProcessor();
        }
        ClientMessageDispatcherImpl dispatcherImpl = new ClientMessageDispatcherImpl(this, socket, this._synchronousMessageQueue, this._asynchronousMessageQueue);
        String dispatcherName = "db4o client side message dispatcher for " + user;
        this._messageDispatcher = dispatcherImpl;
        this.threadPool().start(dispatcherName, dispatcherImpl);
    }

    private void startAsynchronousMessageProcessor() {
        this._asynchronousMessageProcessor = new ClientAsynchronousMessageProcessor(this._asynchronousMessageQueue);
        this.threadPool().start("Client Asynchronous Message Processor Thread for: " + this.toString(), this._asynchronousMessageProcessor);
    }

    @Override
    public void backup(Storage targetStorage, String path) throws NotSupportedException {
        throw new NotSupportedException();
    }

    @Override
    public void closeTransaction(Transaction transaction, boolean isSystemTransaction, boolean rollbackOnClose) {
        if (isSystemTransaction) {
            return;
        }
        this._transaction.close(rollbackOnClose);
    }

    @Override
    public void reserve(int byteCount) {
        throw new NotSupportedException();
    }

    @Override
    public byte blockSize() {
        return (byte)this._blockSize;
    }

    @Override
    protected void close2() {
        if (!(this._singleThreaded || this._messageDispatcher != null && this._messageDispatcher.isMessageDispatcherAlive())) {
            this.stopHeartBeat();
            this.shutdownObjectContainer();
            return;
        }
        try {
            this.commit1(this._transaction);
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
        try {
            this.write(Msg.CLOSE);
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
        this.shutDownCommunicationRessources();
        try {
            this._socket.close();
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
        this.shutdownObjectContainer();
    }

    private void stopHeartBeat() {
        this._heartbeat.stop();
    }

    private void closeMessageDispatcher() {
        try {
            if (!this._singleThreaded) {
                this._messageDispatcher.close();
            }
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
        try {
            if (!this._singleThreaded) {
                this._asynchronousMessageProcessor.stopProcessing();
            }
        }
        catch (Exception e) {
            Exceptions4.catchAllExceptDb4oException(e);
        }
    }

    @Override
    public final void commit1(Transaction trans) {
        trans.commit();
    }

    @Override
    public int converterVersion() {
        return 12;
    }

    Socket4Adapter createParallelSocket() throws IOException {
        this.write(Msg.GET_THREAD_ID);
        int serverThreadID = this.expectedBufferResponse(Msg.ID_LIST).readInt();
        Socket4Adapter sock = this._socket.openParalellSocket();
        this.loginToServer(sock);
        if (this.switchedToFile != null) {
            MsgD message = Msg.SWITCH_TO_FILE.getWriterForString(this.systemTransaction(), this.switchedToFile);
            message.write(sock);
            if (!Msg.OK.equals(Msg.readMessage(this, this.systemTransaction(), sock))) {
                throw new IOException(Messages.get(42));
            }
        }
        Msg.USE_TRANSACTION.getWriterForInt(this._transaction, serverThreadID).write(sock);
        return sock;
    }

    @Override
    public AbstractQueryResult newQueryResult(Transaction trans, QueryEvaluationMode mode) {
        throw new IllegalStateException();
    }

    @Override
    public final Transaction newTransaction(Transaction parentTransaction, ReferenceSystem referenceSystem, boolean isSystemTransaction) {
        return new ClientTransaction(this, parentTransaction, referenceSystem);
    }

    @Override
    public boolean createClassMetadata(ClassMetadata clazz, ReflectClass claxx, ClassMetadata superClazz) {
        this.write(Msg.CREATE_CLASS.getWriterForString(this.systemTransaction(), this.config().resolveAliasRuntimeName(claxx.getName())));
        Msg resp = this.getResponse();
        if (resp == null) {
            return false;
        }
        if (resp.equals(Msg.FAILED)) {
            this.sendClassMeta(claxx);
            resp = this.getResponse();
        }
        if (resp.equals(Msg.FAILED)) {
            if (this.configImpl().exceptionsOnNotStorable()) {
                throw new ObjectNotStorableException(claxx);
            }
            return false;
        }
        if (!resp.equals(Msg.OBJECT_TO_CLIENT)) {
            return false;
        }
        MsgObject message = (MsgObject)resp;
        StatefulBuffer bytes = message.unmarshall();
        if (bytes == null) {
            return false;
        }
        bytes.setTransaction(this.systemTransaction());
        if (!super.createClassMetadata(clazz, claxx, superClazz)) {
            return false;
        }
        clazz.setID(message.getId());
        clazz.readName1(this.systemTransaction(), bytes);
        this.classCollection().addClassMetadata(clazz);
        this.classCollection().readClassMetadata(clazz, claxx);
        return true;
    }

    private void sendClassMeta(ReflectClass reflectClass) {
        ClassInfo classMeta = this._classInfoHelper.getClassMeta(reflectClass);
        this.write(Msg.CLASS_META.getWriter(Serializer.marshall(this.systemTransaction(), (Object)classMeta)));
    }

    @Override
    public long currentVersion() {
        this.write(Msg.CURRENT_VERSION);
        return ((MsgD)this.expectedResponse(Msg.ID_LIST)).readLong();
    }

    @Override
    public final boolean delete4(Transaction ta, ObjectReference yo, Object obj, int a_cascade, boolean userCall) {
        MsgD msg = Msg.DELETE.getWriterForInts(this._transaction, yo.getID(), userCall ? 1 : 0);
        this.writeBatchedMessage(msg);
        return true;
    }

    @Override
    public boolean detectSchemaChanges() {
        return false;
    }

    @Override
    protected boolean doFinalize() {
        return this._doFinalize;
    }

    final ByteArrayBuffer expectedBufferResponse(Msg expectedMessage) {
        Msg msg = this.expectedResponse(expectedMessage);
        if (msg == null) {
            return null;
        }
        return msg.getByteLoad();
    }

    public final Msg expectedResponse(Msg expectedMessage) {
        Msg message = this.getResponse();
        if (expectedMessage.equals(message)) {
            return message;
        }
        this.checkExceptionMessage(message);
        throw new IllegalStateException("Unexpected Message:" + message + "  Expected:" + expectedMessage);
    }

    private void checkExceptionMessage(Msg msg) {
        if (msg instanceof MRuntimeException) {
            ((MRuntimeException)msg).throwPayload();
        }
    }

    @Override
    public AbstractQueryResult queryAllObjects(Transaction trans) {
        int mode = this.config().evaluationMode().asInt();
        MsgD msg = Msg.GET_ALL.getWriterForInts(trans, mode, this.prefetchDepth(), this.prefetchCount());
        this.write(msg);
        return this.readQueryResult(trans);
    }

    @Override
    public final HardObjectReference getHardReferenceBySignature(Transaction trans, long uuid, byte[] signature) {
        int messageLength = 12 + signature.length;
        MsgD message = Msg.OBJECT_BY_UUID.getWriterForLength(trans, messageLength);
        message.writeLong(uuid);
        message.writeInt(signature.length);
        message.writeBytes(signature);
        this.write(message);
        message = (MsgD)this.expectedResponse(Msg.OBJECT_BY_UUID);
        int id = message.readInt();
        if (id > 0) {
            return this.getHardObjectReferenceById(trans, id);
        }
        return HardObjectReference.INVALID;
    }

    public Msg getResponse() {
        Msg msg;
        do {
            Msg msg2 = msg = this._singleThreaded ? this.getResponseSingleThreaded() : this.getResponseMultiThreaded();
        } while (this.isClientSideMessage(msg) && ((ClientSideMessage)((Object)msg)).processAtClient());
        return msg;
    }

    private Msg getResponseSingleThreaded() {
        while (this.isMessageDispatcherAlive()) {
            try {
                Msg message = Msg.readMessage(this, this._transaction, this._socket);
                if (this.isClientSideMessage(message) && ((ClientSideMessage)((Object)message)).processAtClient()) continue;
                return message;
            }
            catch (Db4oIOException exc) {
                this.onMsgError();
            }
        }
        return null;
    }

    private Msg getResponseMultiThreaded() {
        Msg msg;
        try {
            msg = (Msg)this._synchronousMessageQueue.next();
        }
        catch (BlockingQueueStoppedException e) {
            if (DTrace.enabled) {
                DTrace.BLOCKING_QUEUE_STOPPED_EXCEPTION.log(e.toString());
            }
            msg = Msg.ERROR;
        }
        if (msg instanceof MError) {
            this.onMsgError();
        }
        return msg;
    }

    private boolean isClientSideMessage(Msg message) {
        return message instanceof ClientSideMessage;
    }

    private void onMsgError() {
        this.close();
        throw new DatabaseClosedException();
    }

    @Override
    public boolean isMessageDispatcherAlive() {
        return this._socket != null;
    }

    @Override
    public ClassMetadata classMetadataForID(int clazzId) {
        ReflectClass claxx;
        if (clazzId == 0) {
            return null;
        }
        ClassMetadata yc = super.classMetadataForID(clazzId);
        if (yc != null) {
            return yc;
        }
        MsgD msg = Msg.CLASS_NAME_FOR_ID.getWriterForInt(this.systemTransaction(), clazzId);
        this.write(msg);
        MsgD message = (MsgD)this.expectedResponse(Msg.CLASS_NAME_FOR_ID);
        String className = this.config().resolveAliasStoredName(message.readString());
        if (className != null && className.length() > 0 && (claxx = this.reflector().forName(className)) != null) {
            return this.produceClassMetadata(claxx);
        }
        return null;
    }

    @Override
    public boolean needsLockFileThread() {
        return false;
    }

    @Override
    protected boolean hasShutDownHook() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Db4oDatabase identity() {
        if (this.i_db == null) {
            this.write(Msg.IDENTITY);
            ByteArrayBuffer reader = this.expectedBufferResponse(Msg.ID_LIST);
            this.showInternalClasses(true);
            try {
                this.i_db = (Db4oDatabase)this.getByID(this.systemTransaction(), reader.readInt());
                this.activate(this.systemTransaction(), this.i_db, new FixedActivationDepth(3));
            }
            finally {
                this.showInternalClasses(false);
            }
        }
        return this.i_db;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    private void loginToServer(Socket4Adapter iSocket) throws InvalidPasswordException {
        UnicodeStringIO stringWriter = new UnicodeStringIO();
        int length = stringWriter.length(this._userName) + stringWriter.length(this._password);
        MsgD message = Msg.LOGIN.getWriterForLength(this.systemTransaction(), length);
        message.writeString(this._userName);
        message.writeString(this._password);
        message.write(iSocket);
        Msg msg = this.readLoginMessage(iSocket);
        StatefulBuffer payLoad = msg.payLoad();
        this.blockSize(payLoad.readInt());
        int doEncrypt = payLoad.readInt();
        if (doEncrypt == 0) {
            this._handlers.oldEncryptionOff();
        }
        if (payLoad.remainingByteCount() > 0) {
            this._serverSideID = payLoad.readInt();
        }
    }

    private Msg readLoginMessage(Socket4Adapter iSocket) {
        Msg msg = Msg.readMessage(this, this.systemTransaction(), iSocket);
        while (Msg.PONG.equals(msg)) {
            msg = Msg.readMessage(this, this.systemTransaction(), iSocket);
        }
        if (!Msg.LOGIN_OK.equals(msg)) {
            throw new InvalidPasswordException();
        }
        return msg;
    }

    @Override
    public boolean maintainsIndices() {
        return false;
    }

    @Override
    public final int idForNewUserObject(Transaction trans) {
        int prefetchIDCount = this.config().prefetchIDCount();
        this.ensureIDCacheAllocated(prefetchIDCount);
        ByteArrayBuffer reader = null;
        if (this.remainingIDs < 1) {
            MsgD msg = Msg.PREFETCH_IDS.getWriterForInt(this._transaction, prefetchIDCount);
            this.write(msg);
            reader = this.expectedBufferResponse(Msg.ID_LIST);
            for (int i = prefetchIDCount - 1; i >= 0; --i) {
                this._prefetchedIDs[i] = reader.readInt();
            }
            this.remainingIDs = prefetchIDCount;
        }
        --this.remainingIDs;
        return this._prefetchedIDs[this.remainingIDs];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBlobMessage(MsgBlob msg) {
        Object object = this._blobLock;
        synchronized (object) {
            boolean needStart;
            boolean bl = needStart = this._blobTask == null || this._blobTask.isTerminated();
            if (needStart) {
                this._blobTask = new BlobProcessor(this);
            }
            this._blobTask.add(msg);
            if (needStart) {
                this.threadPool().startLowPriority("Blob processor task", this._blobTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raiseCommitTimestamp(long a_minimumVersion) {
        Object object = this.lock();
        synchronized (object) {
            this.write(Msg.RAISE_COMMIT_TIMESTAMP.getWriterForLong(this._transaction, a_minimumVersion));
        }
    }

    @Override
    public void readBytes(byte[] bytes, int address, int addressOffset, int length) {
        throw Exceptions4.virtualException();
    }

    @Override
    public void readBytes(byte[] a_bytes, int a_address, int a_length) {
        MsgD msg = Msg.READ_SLOT.getWriterForInts(this._transaction, a_address, a_length);
        this.write(msg);
        ByteArrayBuffer reader = this.expectedBufferResponse(Msg.READ_SLOT);
        System.arraycopy(reader._buffer, 0, a_bytes, 0, a_length);
    }

    @Override
    protected boolean applyRenames(Config4Impl config) {
        this.logMsg(58, null);
        return false;
    }

    @Override
    public final StatefulBuffer readStatefulBufferById(Transaction a_ta, int a_id) {
        return this.readStatefulBufferById(a_ta, a_id, false);
    }

    @Override
    public final StatefulBuffer readStatefulBufferById(Transaction a_ta, int a_id, boolean lastCommitted) {
        MsgD msg = Msg.READ_OBJECT.getWriterForInts(a_ta, a_id, lastCommitted ? 1 : 0);
        this.write(msg);
        StatefulBuffer bytes = ((MsgObject)this.expectedResponse(Msg.OBJECT_TO_CLIENT)).unmarshall();
        if (bytes != null) {
            bytes.setTransaction(a_ta);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object peekPersisted(Transaction trans, Object obj, ActivationDepth depth, boolean committed) throws DatabaseClosedException {
        this._bypassSlotCache = true;
        try {
            Object object = super.peekPersisted(trans, obj, depth, committed);
            return object;
        }
        finally {
            this._bypassSlotCache = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshInternal(Transaction trans, Object obj, int depth) {
        this._bypassSlotCache = true;
        try {
            super.refreshInternal(trans, obj, depth);
        }
        finally {
            this._bypassSlotCache = false;
        }
    }

    @Override
    public final ByteArrayBuffer[] readSlotBuffers(Transaction transaction, int[] ids) {
        return this.readSlotBuffers(transaction, ids, 1);
    }

    public final ByteArrayBuffer[] readObjectSlots(Transaction transaction, int[] ids) {
        int prefetchDepth = this.config().prefetchDepth();
        return this.readSlotBuffers(transaction, ids, prefetchDepth);
    }

    private ByteArrayBuffer[] readSlotBuffers(Transaction transaction, int[] ids, int prefetchDepth) {
        HashMap<Integer, ByteArrayBuffer> buffers = new HashMap<Integer, ByteArrayBuffer>(ids.length);
        ArrayList<Integer> cacheMisses = this.populateSlotBuffersFromCache(transaction, ids, buffers);
        this.fetchMissingSlotBuffers(transaction, cacheMisses, buffers, prefetchDepth);
        return this.packSlotBuffers(ids, buffers);
    }

    @Override
    public final ByteArrayBuffer readBufferById(Transaction transaction, int id, boolean lastCommitted) {
        if (lastCommitted || this._bypassSlotCache) {
            return this.fetchSlotBuffer(transaction, id, lastCommitted);
        }
        ByteArrayBuffer cached = this._clientSlotCache.get(transaction, id);
        if (cached != null) {
            return cached;
        }
        ByteArrayBuffer slot = this.fetchSlotBuffer(transaction, id, lastCommitted);
        this._clientSlotCache.add(transaction, id, slot);
        return slot;
    }

    @Override
    public final ByteArrayBuffer readBufferById(Transaction a_ta, int a_id) {
        return this.readBufferById(a_ta, a_id, false);
    }

    private AbstractQueryResult readQueryResult(final Transaction trans) {
        final ByRef result = ByRef.newInstance();
        this.withEnvironment(new Runnable(){

            public void run() {
                ByteArrayBuffer reader = ClientObjectContainer.this.expectedBufferResponse(Msg.QUERY_RESULT);
                int queryResultID = reader.readInt();
                AbstractQueryResult queryResult = ClientObjectContainer.this.queryResultFor(trans, queryResultID);
                queryResult.loadFromIdReader(ClientObjectContainer.this.idIteratorFor(trans, reader));
                result.value = queryResult;
            }
        });
        return (AbstractQueryResult)result.value;
    }

    public FixedSizeIntIterator4 idIteratorFor(Transaction trans, ByteArrayBuffer reader) {
        return this.idIteratorFor(this.objectExchangeStrategy(), trans, reader);
    }

    private FixedSizeIntIterator4 idIteratorFor(ObjectExchangeStrategy strategy, Transaction trans, ByteArrayBuffer reader) {
        return strategy.unmarshall((ClientTransaction)trans, this._clientSlotCache, reader);
    }

    private ObjectExchangeStrategy objectExchangeStrategy() {
        return ObjectExchangeStrategyFactory.forConfig(this.defaultObjectExchangeConfiguration());
    }

    private ObjectExchangeConfiguration defaultObjectExchangeConfiguration() {
        return new ObjectExchangeConfiguration(this.prefetchDepth(), this.prefetchCount());
    }

    void readThis() {
        this.write(Msg.GET_CLASSES.getWriter(this.systemTransaction()));
        ByteArrayBuffer bytes = this.expectedBufferResponse(Msg.GET_CLASSES);
        this.classCollection().setID(bytes.readInt());
        byte stringEncoding = bytes.readByte();
        this.createStringIO(stringEncoding);
        this.classCollection().read(this.systemTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSemaphore(Transaction trans, String name) {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            if (name == null) {
                throw new NullPointerException();
            }
            trans = this.checkTransaction(trans);
            this.write(Msg.RELEASE_SEMAPHORE.getWriterForString(trans, name));
        }
    }

    @Override
    public void releaseSemaphore(String name) {
        this.releaseSemaphore(this._transaction, name);
    }

    @Override
    public void releaseSemaphores(Transaction ta) {
    }

    @Override
    public final void rollback1(Transaction trans) {
        if (this._config.batchMessages()) {
            this.clearBatchedObjects();
        }
        this.write(Msg.ROLLBACK);
        trans.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Object obj) {
        Object object = this._lock;
        synchronized (object) {
            if (obj != null) {
                MUserMessage message = Msg.USER_MESSAGE;
                this.write(message.marshallUserMessage(this._transaction, obj));
            }
        }
    }

    @Override
    public final void setDirtyInSystemTransaction(PersistentBase a_object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSemaphore(Transaction trans, String name, int timeout) {
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            trans = this.checkTransaction(trans);
            if (name == null) {
                throw new NullPointerException();
            }
            MsgD msg = Msg.SET_SEMAPHORE.getWriterForIntString(trans, timeout, name);
            this.write(msg);
            Msg message = this.getResponse();
            return message.equals(Msg.SUCCESS);
        }
    }

    @Override
    public boolean setSemaphore(String name, int timeout) {
        return this.setSemaphore(this._transaction, name, timeout);
    }

    @Override
    protected String defaultToString() {
        return "Client connection " + this._userName + "(" + this._socket + ")";
    }

    @Override
    public void shutdown() {
    }

    @Override
    public final void writeDirtyClassMetadata() {
    }

    @Override
    public final boolean write(Msg msg) {
        this.writeMsg(msg, true);
        return true;
    }

    public final void writeBatchedMessage(Msg msg) {
        this.writeMsg(msg, false);
    }

    public final void writeMsg(Msg msg, boolean flush) {
        if (this._config.batchMessages()) {
            if (flush && this._batchedMessages.isEmpty()) {
                this.writeMessageToSocket(msg);
            } else {
                this.addToBatch(msg);
                if (flush || this._batchedQueueLength > this._config.maxBatchQueueSize()) {
                    this.writeBatchedMessages();
                }
            }
        } else if (!this._batchedMessages.isEmpty()) {
            this.addToBatch(msg);
            this.writeBatchedMessages();
        } else {
            this.writeMessageToSocket(msg);
        }
    }

    public boolean writeMessageToSocket(Msg msg) {
        if (this._messageListener != null) {
            this._messageListener.onMessage(msg);
        }
        return msg.write(this._socket);
    }

    @Override
    public final void writeNew(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ByteArrayBuffer buffer) {
        MsgD msg = Msg.WRITE_NEW.getWriter(trans, pointer, classMetadata, buffer);
        this.writeBatchedMessage(msg);
    }

    @Override
    public final void writeUpdate(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ArrayType arrayType, ByteArrayBuffer buffer) {
        MsgD msg = Msg.WRITE_UPDATE.getWriter(trans, pointer, classMetadata, arrayType.value(), buffer);
        this.writeBatchedMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlive() {
        try {
            Object object = this.lock();
            synchronized (object) {
                if (this.isClosed()) {
                    return false;
                }
                this.write(Msg.IS_ALIVE);
                return this.expectedResponse(Msg.IS_ALIVE) != null;
            }
        }
        catch (Db4oException exc) {
            return false;
        }
    }

    public Socket4Adapter socket() {
        return this._socket;
    }

    private void ensureIDCacheAllocated(int prefetchIDCount) {
        if (this._prefetchedIDs == null) {
            this._prefetchedIDs = new int[prefetchIDCount];
            return;
        }
        if (prefetchIDCount > this._prefetchedIDs.length) {
            int[] newPrefetchedIDs = new int[prefetchIDCount];
            System.arraycopy(this._prefetchedIDs, 0, newPrefetchedIDs, 0, this._prefetchedIDs.length);
            this._prefetchedIDs = newPrefetchedIDs;
        }
    }

    @Override
    public SystemInfo systemInfo() {
        throw new NotImplementedException("Functionality not availble on clients.");
    }

    @Override
    public void writeBlobTo(Transaction trans, BlobImpl blob) throws IOException {
        MsgBlob msg = (MsgBlob)Msg.READ_BLOB.getWriterForInt(trans, (int)this.getID(blob));
        msg._blob = blob;
        this.processBlobMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBlobFrom(Transaction trans, BlobImpl blob) throws IOException {
        MsgBlob msg = null;
        Object object = this.lock();
        synchronized (object) {
            this.store(blob);
            int id = (int)this.getID(blob);
            msg = (MsgBlob)Msg.WRITE_BLOB.getWriterForInt(trans, id);
            msg._blob = blob;
            blob.setStatus(-3.0);
        }
        this.processBlobMessage(msg);
    }

    @Override
    public void deleteBlobFile(Transaction trans, BlobImpl blob) {
        MDeleteBlobFile msg = (MDeleteBlobFile)Msg.DELETE_BLOB_FILE.getWriterForInt(trans, (int)this.getID(blob));
        this.writeMsg(msg, false);
    }

    @Override
    public long[] getIDsForClass(Transaction trans, ClassMetadata clazz) {
        boolean triggerQueryEvents = false;
        return this.getIDsForClass(trans, clazz, triggerQueryEvents);
    }

    private long[] getIDsForClass(final Transaction trans, ClassMetadata clazz, boolean triggerQueryEvents) {
        MsgD msg = Msg.GET_INTERNAL_IDS.getWriterForInts(trans, clazz.getID(), this.prefetchDepth(), this.prefetchCount(), triggerQueryEvents ? 1 : 0);
        this.write(msg);
        final ByRef result = ByRef.newInstance();
        this.withEnvironment(new Runnable(){

            public void run() {
                ByteArrayBuffer reader = ClientObjectContainer.this.expectedBufferResponse(Msg.ID_LIST);
                FixedSizeIntIterator4 idIterator = ClientObjectContainer.this.idIteratorFor(trans, reader);
                result.value = ClientObjectContainer.this.toLongArray(idIterator);
            }
        });
        return (long[])result.value;
    }

    @Override
    public QueryResult classOnlyQuery(QQueryBase query, ClassMetadata clazz) {
        Transaction trans = query.transaction();
        long[] ids = this.getIDsForClass(trans, clazz, true);
        ClientQueryResult resClient = new ClientQueryResult(trans, ids.length);
        for (int i = 0; i < ids.length; ++i) {
            resClient.add((int)ids[i]);
        }
        return resClient;
    }

    private long[] toLongArray(FixedSizeIntIterator4 idIterator) {
        long[] ids = new long[idIterator.size()];
        int i = 0;
        while (idIterator.moveNext()) {
            ids[i++] = ((Integer)idIterator.current()).intValue();
        }
        return ids;
    }

    int prefetchDepth() {
        return this._config.prefetchDepth();
    }

    int prefetchCount() {
        return this._config.prefetchObjectCount();
    }

    @Override
    public QueryResult executeQuery(QQuery query) {
        Transaction trans = query.transaction();
        query.captureQueryResultConfig();
        query.marshall();
        MsgD msg = Msg.QUERY_EXECUTE.getWriter(Serializer.marshall(trans, (Object)query));
        this.write(msg);
        return this.readQueryResult(trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeBatchedMessages() {
        Object object = this.lock();
        synchronized (object) {
            if (this._batchedMessages.isEmpty()) {
                return;
            }
            MsgD multibytes = Msg.WRITE_BATCHED_MESSAGES.getWriterForLength(this.transaction(), this._batchedQueueLength);
            multibytes.writeInt(this._batchedMessages.size());
            Iterator4 iter = this._batchedMessages.iterator();
            while (iter.moveNext()) {
                Msg msg = (Msg)iter.current();
                if (msg == null) {
                    multibytes.writeInt(0);
                    continue;
                }
                multibytes.writeInt(msg.payLoad().length());
                multibytes.payLoad().append(msg.payLoad()._buffer);
            }
            this.writeMessageToSocket(multibytes);
            this.clearBatchedObjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToBatch(Msg msg) {
        Object object = this.lock();
        synchronized (object) {
            this._batchedMessages.add(msg);
            this._batchedQueueLength += 4 + msg.payLoad().length();
        }
    }

    private final void clearBatchedObjects() {
        this._batchedMessages.clear();
        this._batchedQueueLength = 4;
    }

    int timeout() {
        return this.configImpl().timeoutClientSocket();
    }

    @Override
    protected void shutdownDataStorage() {
        this.shutDownCommunicationRessources();
    }

    private void shutDownCommunicationRessources() {
        this.stopHeartBeat();
        this.closeMessageDispatcher();
        this._synchronousMessageQueue.stop();
        this._asynchronousMessageQueue.stop();
    }

    public void setDispatcherName(String name) {
    }

    public ClientMessageDispatcher messageDispatcher() {
        return this._singleThreaded ? this : this._messageDispatcher;
    }

    public void onCommittedListenerAdded() {
        if (this._singleThreaded) {
            return;
        }
        this.write(Msg.COMMITTED_CALLBACK_REGISTER);
        this.expectedResponse(Msg.OK);
    }

    @Override
    public ClassMetadata classMetadataForReflectClass(ReflectClass claxx) {
        ClassMetadata classMetadata = super.classMetadataForReflectClass(claxx);
        if (classMetadata != null) {
            return classMetadata;
        }
        String className = this.config().resolveAliasRuntimeName(claxx.getName());
        if (this.classMetadataIdForName(className) == 0) {
            return null;
        }
        return this.produceClassMetadata(claxx);
    }

    @Override
    public int classMetadataIdForName(String name) {
        MsgD msg = Msg.CLASS_METADATA_ID_FOR_NAME.getWriterForString(this.systemTransaction(), name);
        msg.write(this._socket);
        MsgD response = (MsgD)this.expectedResponse(Msg.CLASS_ID);
        return response.readInt();
    }

    @Override
    public int instanceCount(ClassMetadata clazz, Transaction trans) {
        MsgD msg = Msg.INSTANCE_COUNT.getWriterForInt(trans, clazz.getID());
        this.write(msg);
        MsgD response = (MsgD)this.expectedResponse(Msg.INSTANCE_COUNT);
        return response.readInt();
    }

    public void messageListener(MessageListener listener) {
        this._messageListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAll(Transaction transaction, Iterator4 objects) {
        boolean configuredBatchMessages = this._config.batchMessages();
        this._config.batchMessages(true);
        try {
            super.storeAll(transaction, objects);
        }
        finally {
            this._config.batchMessages(configuredBatchMessages);
        }
    }

    private void sendReadMultipleObjectsMessage(MReadMultipleObjects message, Transaction transaction, int prefetchDepth, List<Integer> idsToRead) {
        MsgD msg = message.getWriterForLength(transaction, 8 + 4 * idsToRead.size());
        msg.writeInt(prefetchDepth);
        msg.writeInt(idsToRead.size());
        for (int id : idsToRead) {
            msg.writeInt(id);
        }
        this.write(msg);
    }

    private AbstractQueryResult queryResultFor(Transaction trans, int queryResultID) {
        if (queryResultID > 0) {
            return new LazyClientQueryResult(trans, this, queryResultID);
        }
        return new ClientQueryResult(trans);
    }

    private void fetchMissingSlotBuffers(Transaction transaction, ArrayList<Integer> missing, Map<Integer, ByteArrayBuffer> buffers, int prefetchDepth) {
        if (missing.size() == 0) {
            return;
        }
        int safePrefetchDepth = Math.max(1, prefetchDepth);
        this.sendReadMultipleObjectsMessage(Msg.READ_MULTIPLE_OBJECTS, transaction, safePrefetchDepth, missing);
        MsgD response = (MsgD)this.expectedResponse(Msg.READ_MULTIPLE_OBJECTS);
        Iterator4<Pair<Integer, ByteArrayBuffer>> slots = new CacheContributingObjectReader((ClientTransaction)transaction, this._clientSlotCache, response.payLoad()).buffers();
        while (slots.moveNext()) {
            Pair<Integer, ByteArrayBuffer> pair = slots.current();
            buffers.put((Integer)pair.first, (ByteArrayBuffer)pair.second);
        }
    }

    private ByteArrayBuffer[] packSlotBuffers(int[] ids, Map<Integer, ByteArrayBuffer> buffers) {
        ByteArrayBuffer[] returnValue = new ByteArrayBuffer[buffers.size()];
        for (int i = 0; i < ids.length; ++i) {
            returnValue[i] = buffers.get(ids[i]);
        }
        return returnValue;
    }

    private ArrayList<Integer> populateSlotBuffersFromCache(Transaction transaction, int[] ids, Map<Integer, ByteArrayBuffer> buffers) {
        ArrayList<Integer> missing = new ArrayList<Integer>();
        for (int id : ids) {
            ByteArrayBuffer slot = this._clientSlotCache.get(transaction, id);
            if (null == slot) {
                missing.add(id);
                continue;
            }
            buffers.put(id, slot);
        }
        return missing;
    }

    private ByteArrayBuffer fetchSlotBuffer(Transaction transaction, int id, boolean lastCommitted) {
        MsgD msg = Msg.READ_READER_BY_ID.getWriterForInts(transaction, id, lastCommitted ? 1 : 0);
        this.write(msg);
        ByteArrayBuffer buffer = ((MReadBytes)this.expectedResponse(Msg.READ_BYTES)).unmarshall();
        return buffer;
    }

    @Override
    protected void fatalStorageShutdown() {
        this.shutdownDataStorage();
    }

    public String userName() {
        return this._userName;
    }

    @Override
    public boolean isDeleted(Transaction trans, int id) {
        MsgD msg = Msg.TA_IS_DELETED.getWriterForInt(trans, id);
        this.write(msg);
        int res = this.expectedBufferResponse(Msg.TA_IS_DELETED).readInt();
        return res == 1;
    }

    @Override
    public void blockSize(int size) {
        this.createBlockConverter(size);
        this._blockSize = size;
    }

    @Override
    protected void closeIdSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectContainer openSession() {
        Object object = this.lock();
        synchronized (object) {
            return new ObjectContainerSession(this);
        }
    }

    public int serverSideID() {
        return this._serverSideID;
    }

    @Override
    public EventRegistryImpl newEventRegistry() {
        return new ClientEventRegistryImpl(this);
    }

    public <T> QLin<T> from(Class<T> clazz) {
        return new QLinRoot<T>(this.query(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitReplication(long replicationRecordId, long timestamp) {
        Object object = this._lock;
        synchronized (object) {
            this.checkReadOnly();
            ClientTransaction clientTransaction = (ClientTransaction)this.transaction();
            clientTransaction.preCommit();
            this.write(Msg.COMMIT_REPLICATION.getWriterForLongs(clientTransaction, replicationRecordId, timestamp));
            this.expectedResponse(Msg.OK);
            clientTransaction.postCommit();
        }
    }

    public static interface MessageListener {
        public void onMessage(Msg var1);
    }
}

