/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.foundation;

import com.db4o.cs.foundation.Socket4;
import com.db4o.internal.Platform4;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public abstract class NetworkSocketBase
implements Socket4 {
    private String _hostName;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;

    public NetworkSocketBase(Socket socket) throws IOException {
        this(socket, null);
    }

    public NetworkSocketBase(Socket socket, String hostName) throws IOException {
        this._socket = socket;
        this._hostName = hostName;
        this._in = this._socket.getInputStream();
        this._out = this._socket.getOutputStream();
    }

    public void close() throws IOException {
        this._socket.close();
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public boolean isConnected() {
        return Platform4.isConnected(this._socket);
    }

    public int read(byte[] a_bytes, int a_offset, int a_length) throws IOException {
        int ret = this._in.read(a_bytes, a_offset, a_length);
        this.checkEOF(ret);
        return ret;
    }

    private void checkEOF(int ret) throws IOException {
        if (ret == -1) {
            throw new IOException();
        }
    }

    public void setSoTimeout(int timeout) {
        try {
            this._socket.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        this._out.write(bytes, off, len);
    }

    public Socket4 openParallelSocket() throws IOException {
        if (this._hostName == null) {
            throw new IllegalStateException();
        }
        return this.createParallelSocket(this._hostName, this._socket.getPort());
    }

    protected abstract Socket4 createParallelSocket(String var1, int var2) throws IOException;

    public String toString() {
        return this._socket.toString();
    }
}

