/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.activation.ActivationPurpose;
import com.db4o.collections.ActivatingIterator;
import com.db4o.ta.Activatable;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingActivatableCollection<E>
implements Collection<E> {
    private final Collection<E> _delegate;
    private final Activatable _activatable;

    DelegatingActivatableCollection(Collection<E> delegate, Activatable activatable) {
        this._delegate = delegate;
        this._activatable = activatable;
    }

    @Override
    public boolean add(E e) {
        this.activateForWrite();
        return this._delegate.add(e);
    }

    private void activateForWrite() {
        this._activatable.activate(ActivationPurpose.WRITE);
    }

    private void activateForRead() {
        this._activatable.activate(ActivationPurpose.READ);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.activateForWrite();
        return this._delegate.addAll(c);
    }

    @Override
    public void clear() {
        this.activateForWrite();
        this._delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        this.activateForRead();
        return this._delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.activateForRead();
        return this._delegate.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        this.activateForRead();
        return this._delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.activateForRead();
        return new ActivatingIterator<E>(this._activatable, this._delegate.iterator());
    }

    @Override
    public boolean remove(Object o) {
        this.activateForWrite();
        return this._delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.activateForWrite();
        return this._delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.activateForWrite();
        return this._delegate.retainAll(c);
    }

    @Override
    public int size() {
        this.activateForRead();
        return this._delegate.size();
    }

    @Override
    public Object[] toArray() {
        this.activateForRead();
        return this._delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.activateForRead();
        return this._delegate.toArray(a);
    }
}

