/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.context;

import EDU.purdue.cs.bloat.context.PersistentBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.file.ClassFile;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BloatingClassLoader
extends URLClassLoader {
    ClassInfoLoader loader = new BloatingClassInfoLoader();
    private final EditorContext context = new PersistentBloatContext(this.loader, false);
    private final Map classBytes = new HashMap();

    public BloatingClassLoader(URL[] urls) {
        super(urls);
    }

    public BloatingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        ClassInfo info = this.loader.loadClass(name);
        ClassEditor ce = this.context.editClass(info);
        this.bloat(ce);
        ce.commit();
        ByteArrayOutputStream baos = (ByteArrayOutputStream)this.classBytes.get(info);
        Assert.isNotNull(baos, "No bytes for " + name);
        byte[] bytes = baos.toByteArray();
        return super.defineClass(name, bytes, 0, bytes.length);
    }

    public ClassInfoLoader getClassInfoLoader() {
        return this.loader;
    }

    protected EditorContext getEditorContext() {
        return this.context;
    }

    protected abstract void bloat(ClassEditor var1);

    class BloatingClassInfoLoader
    implements ClassInfoLoader {
        BloatingClassInfoLoader() {
        }

        public ClassInfo loadClass(String name) throws ClassNotFoundException {
            String classFileName = String.valueOf(name.replace('.', '/')) + ".class";
            InputStream is = ((ClassLoader)BloatingClassLoader.this).getResourceAsStream(classFileName);
            if (is == null) {
                throw new ClassNotFoundException("Could not find class " + name);
            }
            DataInputStream dis = new DataInputStream(is);
            return new ClassFile(null, this, dis);
        }

        public ClassInfo newClass(int modifiers, int classIndex, int superClassIndex, int[] interfaceIndexes, List constants) {
            return new ClassFile(modifiers, classIndex, superClassIndex, interfaceIndexes, constants, this);
        }

        public OutputStream outputStreamFor(ClassInfo info) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BloatingClassLoader.this.classBytes.put(info, os);
            return os;
        }
    }
}

