/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.btree;

import com.db4o.Null;
import com.db4o.Transaction;
import com.db4o.YapMeta;
import com.db4o.YapReader;
import com.db4o.foundation.No4;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.btree.BTree;
import com.db4o.inside.btree.BTreeAdd;
import com.db4o.inside.btree.BTreePatch;
import com.db4o.inside.btree.BTreeRemove;
import com.db4o.inside.btree.Searcher;
import com.db4o.inside.ix.Indexable4;

public class BTreeNode
extends YapMeta {
    private static final int COUNT_LEAF_AND_3_LINK_LENGTH = 17;
    private static final int SLOT_LEADING_LENGTH = 17;
    final BTree _btree;
    private int _count;
    private boolean _isLeaf;
    private Object[] _keys;
    private Object[] _children;
    private Object[] _values;
    private int _parentID;
    private int _previousID;
    private int _nextID;
    private boolean _cached;
    private boolean _dead;

    public BTreeNode(BTree bTree, int n, boolean bl, int n2, int n3, int n4) {
        this._btree = bTree;
        this._parentID = n2;
        this._previousID = n3;
        this._nextID = n4;
        this._count = n;
        this._isLeaf = bl;
        this.prepareArrays();
        this.setStateDirty();
    }

    public BTreeNode(int n, BTree bTree) {
        this._btree = bTree;
        this.setID(n);
        this.setStateDeactivated();
    }

    public BTreeNode(Transaction transaction, BTreeNode bTreeNode, BTreeNode bTreeNode2) {
        this(bTreeNode._btree, 2, false, 0, 0, 0);
        this._keys[0] = bTreeNode._keys[0];
        this._children[0] = bTreeNode;
        this._keys[1] = bTreeNode2._keys[0];
        this._children[1] = bTreeNode2;
        this.write(transaction.systemTransaction());
        bTreeNode._parentID = this.getID();
        bTreeNode2._parentID = this.getID();
    }

    public BTreeNode add(Transaction transaction) {
        YapReader yapReader = this.prepareRead(transaction);
        Searcher searcher = this.search(transaction, yapReader);
        if (this._isLeaf) {
            this.prepareWrite(transaction);
            if (searcher._cmp < 0) {
                ++searcher._cursor;
            }
            this.insert(searcher._cursor);
            this._keys[searcher._cursor] = new BTreeAdd(transaction, this.keyHandler().current());
            if (this.handlesValues()) {
                this._values[searcher._cursor] = this.valueHandler().current();
            }
        } else {
            BTreeNode bTreeNode = this.child(yapReader, searcher._cursor);
            BTreeNode bTreeNode2 = bTreeNode.add(transaction);
            if (bTreeNode2 == null) {
                return null;
            }
            this.prepareWrite(transaction);
            this._keys[searcher._cursor] = bTreeNode._keys[0];
            if (bTreeNode != bTreeNode2) {
                int n = searcher._cursor + 1;
                this.insert(n);
                this._keys[n] = bTreeNode2._keys[0];
                this._children[n] = bTreeNode2;
            }
        }
        if (this._count >= this._btree._nodeSize) {
            return this.split(transaction);
        }
        if (searcher._cursor == 0) {
            return this;
        }
        return null;
    }

    private boolean canWrite() {
        return this._keys != null;
    }

    private BTreeNode child(int n) {
        if (this._children[n] instanceof BTreeNode) {
            return (BTreeNode)this._children[n];
        }
        return this._btree.produceNode((Integer)this._children[n]);
    }

    private BTreeNode child(YapReader yapReader, int n) {
        if (this.childLoaded(n)) {
            return (BTreeNode)this._children[n];
        }
        BTreeNode bTreeNode = this._btree.produceNode(this.childID(yapReader, n));
        if (this._children != null && (this._cached || bTreeNode.canWrite())) {
            this._children[n] = bTreeNode;
        }
        return bTreeNode;
    }

    private int childID(YapReader yapReader, int n) {
        if (this._children == null) {
            this.seekChild(yapReader, n);
            return yapReader.readInt();
        }
        return this.childID(n);
    }

    private int childID(int n) {
        if (this.childLoaded(n)) {
            return ((BTreeNode)this._children[n]).getID();
        }
        return (Integer)this._children[n];
    }

    private boolean childLoaded(int n) {
        if (this._children == null) {
            return false;
        }
        return this._children[n] instanceof BTreeNode;
    }

    private boolean childCanSupplyFirstKey(int n) {
        if (!this.childLoaded(n)) {
            return false;
        }
        return ((BTreeNode)this._children[n])._keys != null;
    }

    void commit(Transaction transaction) {
        if (this._dead) {
            return;
        }
        this._cached = false;
        if (!this.canWrite()) {
            return;
        }
        if (!this.isDirty(transaction)) {
            return;
        }
        Object object = this._keys[0];
        if (this._isLeaf) {
            boolean bl = this.handlesValues();
            Object[] objectArray = new Object[this._btree._nodeSize];
            Object[] objectArray2 = bl ? new Object[this._btree._nodeSize] : null;
            int n = 0;
            for (int i = 0; i < this._count; ++i) {
                Object object2 = this._keys[i];
                BTreePatch bTreePatch = this.keyPatch(i);
                if (bTreePatch != null) {
                    object2 = bTreePatch.commit(transaction, this._btree);
                }
                if (object2 == No4.INSTANCE) continue;
                objectArray[n] = object2;
                if (bl) {
                    objectArray2[n] = this._values[i];
                }
                ++n;
            }
            this._keys = objectArray;
            this._values = objectArray2;
            this._count = n;
            if (this._count == 0 && this._parentID != 0) {
                this.free(transaction);
                return;
            }
        }
        if (this._keys[0] != object) {
            this.tellParentAboutChangedKey(transaction);
        }
    }

    private void free(Transaction transaction) {
        this._dead = true;
        if (this._parentID != 0) {
            BTreeNode bTreeNode = this._btree.produceNode(this._parentID);
            bTreeNode.removeChild(transaction, this);
        }
        this.pointPreviousTo(transaction, this._nextID);
        this.pointNextTo(transaction, this._previousID);
        transaction.systemTransaction().slotFreePointerOnCommit(this.getID());
        this._btree.removeNode(this);
    }

    void holdChildrenAsIDs() {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (!(this._children[i] instanceof BTreeNode)) continue;
            this._children[i] = new Integer(((BTreeNode)this._children[i]).getID());
        }
    }

    private void removeChild(Transaction transaction, BTreeNode bTreeNode) {
        this.prepareWrite(transaction);
        int n = bTreeNode.getID();
        for (int i = 0; i < this._count; ++i) {
            if (this.childID(i) != n) continue;
            if (this._count == 1 && this._parentID != 0) {
                this.free(transaction);
                return;
            }
            this.remove(i);
            if (i <= 1 && this._parentID != 0) {
                BTreeNode bTreeNode2 = this._btree.produceNode(this._parentID);
                bTreeNode2.keyChanged(transaction, this);
                return;
            }
            if (this._count != 0) continue;
            this._isLeaf = true;
        }
    }

    private void keyChanged(Transaction transaction, BTreeNode bTreeNode) {
        this.prepareWrite(transaction);
        int n = bTreeNode.getID();
        for (int i = 0; i < this._count; ++i) {
            if (this.childID(i) != n) continue;
            this._keys[i] = bTreeNode._keys[0];
            this._children[i] = bTreeNode;
            if (i == 0) {
                this.tellParentAboutChangedKey(transaction);
            }
            return;
        }
    }

    private void tellParentAboutChangedKey(Transaction transaction) {
        if (this._parentID != 0) {
            BTreeNode bTreeNode = this._btree.produceNode(this._parentID);
            bTreeNode.keyChanged(transaction, this);
        }
    }

    private boolean isDirty(Transaction transaction) {
        if (!this.canWrite()) {
            return false;
        }
        for (int i = 0; i < this._count; ++i) {
            BTreePatch bTreePatch = this.keyPatch(i);
            if (bTreePatch == null || bTreePatch.forTransaction(transaction) == null) continue;
            return true;
        }
        return false;
    }

    private void compare(Searcher searcher, YapReader yapReader) {
        Indexable4 indexable4 = this.keyHandler();
        if (this._keys != null) {
            searcher.resultIs(indexable4.compareTo(this.key(searcher._cursor)));
        } else {
            this.seekKey(yapReader, searcher._cursor);
            searcher.resultIs(indexable4.compareTo(indexable4.readIndexEntry(yapReader)));
        }
    }

    private int entryLength() {
        int n = this.keyHandler().linkLength();
        if (this._isLeaf) {
            if (this.handlesValues()) {
                n += this.valueHandler().linkLength();
            }
        } else {
            n += 4;
        }
        return n;
    }

    private Object firstKey(Transaction transaction) {
        for (int i = 0; i < this._count; ++i) {
            BTreePatch bTreePatch = this.keyPatch(i);
            if (bTreePatch == null) {
                return this._keys[i];
            }
            Object object = bTreePatch.getObject(transaction);
            if (object == No4.INSTANCE) continue;
            return object;
        }
        return No4.INSTANCE;
    }

    public byte getIdentifier() {
        return 66;
    }

    private boolean handlesValues() {
        return this._btree._valueHandler != Null.INSTANCE;
    }

    private void insert(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this._count - 1) {
            ++this._count;
            return;
        }
        int n2 = this._count - n;
        System.arraycopy(this._keys, n, this._keys, n + 1, n2);
        if (this._values != null) {
            System.arraycopy(this._values, n, this._values, n + 1, n2);
        }
        if (this._children != null) {
            System.arraycopy(this._children, n, this._children, n + 1, n2);
        }
        ++this._count;
    }

    private void remove(int n) {
        int n2 = this._count - n;
        --this._count;
        System.arraycopy(this._keys, n + 1, this._keys, n, n2);
        this._keys[this._count] = null;
        if (this._values != null) {
            System.arraycopy(this._values, n + 1, this._values, n, n2);
            this._values[this._count] = null;
        }
        if (this._children != null) {
            System.arraycopy(this._children, n + 1, this._children, n, n2);
            this._children[this._count] = null;
        }
    }

    private Object key(int n) {
        BTreePatch bTreePatch = this.keyPatch(n);
        if (bTreePatch == null) {
            return this._keys[n];
        }
        return bTreePatch._object;
    }

    private Object key(Transaction transaction, YapReader yapReader, int n) {
        if (this._keys != null) {
            return this.key(transaction, n);
        }
        this.seekKey(yapReader, n);
        return this.keyHandler().readIndexEntry(yapReader);
    }

    private Object key(Transaction transaction, int n) {
        BTreePatch bTreePatch = this.keyPatch(n);
        if (bTreePatch == null) {
            return this._keys[n];
        }
        return bTreePatch.getObject(transaction);
    }

    private BTreePatch keyPatch(int n) {
        if (this._keys[n] instanceof BTreePatch) {
            return (BTreePatch)this._keys[n];
        }
        return null;
    }

    private Indexable4 keyHandler() {
        return this._btree._keyHandler;
    }

    void markAsCached(int n) {
        this._cached = true;
        this._btree.addNode(this);
        if (this._isLeaf || this._children == null) {
            return;
        }
        if (--n < 1) {
            this.holdChildrenAsIDs();
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (!(this._children[i] instanceof BTreeNode)) continue;
            ((BTreeNode)this._children[i]).markAsCached(n);
        }
    }

    public int ownLength() {
        return 17 + this._count * this.entryLength() + 0;
    }

    private YapReader prepareRead(Transaction transaction) {
        if (this.canWrite()) {
            return null;
        }
        if (this.isNew()) {
            return null;
        }
        if (this._cached) {
            this.read(transaction.systemTransaction());
            this._btree.addToProcessing(this);
            return null;
        }
        YapReader yapReader = transaction.i_file.readReaderByID(transaction.systemTransaction(), this.getID());
        this.readSlotHeader(yapReader);
        return yapReader;
    }

    void prepareWrite(Transaction transaction) {
        if (this._dead) {
            return;
        }
        if (this.canWrite()) {
            this.setStateDirty();
            return;
        }
        if (this._keys == null) {
            this.read(transaction.systemTransaction());
            this.setStateDirty();
            this._btree.addToProcessing(this);
        }
    }

    void prepareArrays() {
        if (this._keys != null) {
            return;
        }
        this._keys = new Object[this._btree._nodeSize];
        if (this._isLeaf) {
            if (this.handlesValues()) {
                this._values = new Object[this._btree._nodeSize];
            }
        } else {
            this._children = new Object[this._btree._nodeSize];
        }
    }

    private void readSlotHeader(YapReader yapReader) {
        this._count = yapReader.readInt();
        byte by = yapReader.readByte();
        this._isLeaf = by == 1;
        this._parentID = yapReader.readInt();
        this._previousID = yapReader.readInt();
        this._nextID = yapReader.readInt();
    }

    public void readThis(Transaction transaction, YapReader yapReader) {
        this.readSlotHeader(yapReader);
        this.prepareArrays();
        boolean bl = !this._isLeaf;
        boolean bl2 = this.handlesValues() && this._isLeaf;
        for (int i = 0; i < this._count; ++i) {
            this._keys[i] = this.keyHandler().readIndexEntry(yapReader);
            if (bl2) {
                this._values[i] = this.valueHandler().readIndexEntry(yapReader);
                continue;
            }
            if (!bl) continue;
            this._children[i] = new Integer(yapReader.readInt());
        }
    }

    public void remove(Transaction transaction) {
        YapReader yapReader = this.prepareRead(transaction);
        Searcher searcher = this.search(transaction, yapReader);
        if (searcher._cursor < 0) {
            return;
        }
        if (this._isLeaf) {
            if (searcher._cmp != 0) {
                return;
            }
            this.prepareWrite(transaction);
            BTreeRemove bTreeRemove = new BTreeRemove(transaction, this.keyHandler().current());
            BTreePatch bTreePatch = this.keyPatch(searcher._cursor);
            this._keys[searcher._cursor] = bTreePatch != null ? bTreePatch.append(bTreeRemove) : bTreeRemove;
            if (searcher._cursor == 0) {
                this.tellParentAboutChangedKey(transaction);
            }
            return;
        }
        this.child(yapReader, searcher._cursor).remove(transaction);
    }

    void rollback(Transaction transaction) {
        if (!this.canWrite()) {
            return;
        }
        if (this._isLeaf) {
            Object object = this._keys[0];
            boolean bl = this.handlesValues();
            Object[] objectArray = new Object[this._btree._nodeSize];
            Object[] objectArray2 = bl ? new Object[this._btree._nodeSize] : null;
            int n = 0;
            for (int i = 0; i < this._count; ++i) {
                Object object2 = this._keys[i];
                BTreePatch bTreePatch = this.keyPatch(i);
                if (bTreePatch != null) {
                    object2 = bTreePatch.rollback(transaction, this._btree);
                }
                if (object2 == No4.INSTANCE) continue;
                objectArray[n] = object2;
                if (bl) {
                    objectArray2[n] = this._values[i];
                }
                ++n;
            }
            this._keys = objectArray;
            this._values = objectArray2;
            this._count = n;
            if (object != this._keys[0]) {
                this.tellParentAboutChangedKey(transaction);
            }
        }
    }

    private Searcher search(Transaction transaction, YapReader yapReader) {
        Searcher searcher = new Searcher(this._count);
        while (searcher.incomplete()) {
            this.compare(searcher, yapReader);
        }
        if (searcher._cursor < 0) {
            searcher._cursor = 0;
        } else if (!this._isLeaf && searcher._cmp > 0 && searcher._cursor > 0) {
            --searcher._cursor;
        }
        return searcher;
    }

    private void seekAfterKey(YapReader yapReader, int n) {
        this.seekKey(yapReader, n);
        yapReader._offset += this.keyHandler().linkLength();
    }

    private void seekChild(YapReader yapReader, int n) {
        this.seekAfterKey(yapReader, n);
    }

    private void seekKey(YapReader yapReader, int n) {
        yapReader._offset = 17 + this.entryLength() * n;
    }

    private void seekValue(YapReader yapReader, int n) {
        if (this.handlesValues()) {
            this.seekAfterKey(yapReader, n);
        } else {
            this.seekKey(yapReader, n);
        }
    }

    private BTreeNode split(Transaction transaction) {
        int n;
        BTreeNode bTreeNode = new BTreeNode(this._btree, this._btree._halfNodeSize, this._isLeaf, this._parentID, this.getID(), this._nextID);
        System.arraycopy(this._keys, this._btree._halfNodeSize, bTreeNode._keys, 0, this._btree._halfNodeSize);
        for (n = this._btree._halfNodeSize; n < this._keys.length; ++n) {
            this._keys[n] = null;
        }
        if (this._values != null) {
            bTreeNode._values = new Object[this._btree._nodeSize];
            System.arraycopy(this._values, this._btree._halfNodeSize, bTreeNode._values, 0, this._btree._halfNodeSize);
            for (n = this._btree._halfNodeSize; n < this._values.length; ++n) {
                this._values[n] = null;
            }
        }
        if (this._children != null) {
            bTreeNode._children = new Object[this._btree._nodeSize];
            System.arraycopy(this._children, this._btree._halfNodeSize, bTreeNode._children, 0, this._btree._halfNodeSize);
            for (n = this._btree._halfNodeSize; n < this._children.length; ++n) {
                this._children[n] = null;
            }
        }
        this._count = this._btree._halfNodeSize;
        bTreeNode.write(transaction.systemTransaction());
        this._btree.addNode(bTreeNode);
        n = bTreeNode.getID();
        this.pointNextTo(transaction, n);
        this.setNextID(transaction, n);
        if (this._children != null) {
            for (int i = 0; i < this._btree._halfNodeSize && bTreeNode._children[i] != null; ++i) {
                bTreeNode.child(i).setParentID(transaction, n);
            }
        }
        return bTreeNode;
    }

    private void pointNextTo(Transaction transaction, int n) {
        if (this._nextID > 0) {
            this._btree.produceNode(this._nextID).setPreviousID(transaction, n);
        }
    }

    private void pointPreviousTo(Transaction transaction, int n) {
        if (this._previousID != 0) {
            this._btree.produceNode(this._previousID).setNextID(transaction, n);
        }
    }

    void purge() {
        if (this._dead) {
            this._keys = null;
            this._values = null;
            this._children = null;
            return;
        }
        if (this._cached) {
            return;
        }
        if (this._keys == null) {
            return;
        }
        for (int i = 0; i < this._count; ++i) {
            if (!(this._keys[i] instanceof BTreePatch)) continue;
            this.holdChildrenAsIDs();
            this._btree.addNode(this);
            return;
        }
    }

    private void setParentID(Transaction transaction, int n) {
        this.prepareWrite(transaction);
        this._parentID = n;
    }

    private void setPreviousID(Transaction transaction, int n) {
        this.prepareWrite(transaction);
        this._previousID = n;
    }

    private void setNextID(Transaction transaction, int n) {
        this.prepareWrite(transaction);
        this._nextID = n;
    }

    public void traverseKeys(Transaction transaction, Visitor4 visitor4) {
        YapReader yapReader = this.prepareRead(transaction);
        if (this._isLeaf) {
            for (int i = 0; i < this._count; ++i) {
                Object object = this.key(transaction, yapReader, i);
                if (object == No4.INSTANCE) continue;
                visitor4.visit(object);
            }
        } else {
            for (int i = 0; i < this._count; ++i) {
                this.child(yapReader, i).traverseKeys(transaction, visitor4);
            }
        }
    }

    public void traverseValues(Transaction transaction, Visitor4 visitor4) {
        if (!this.handlesValues()) {
            this.traverseKeys(transaction, visitor4);
            return;
        }
        YapReader yapReader = this.prepareRead(transaction);
        if (this._isLeaf) {
            for (int i = 0; i < this._count; ++i) {
                if (this.key(transaction, yapReader, i) == No4.INSTANCE) continue;
                visitor4.visit(this.value(yapReader, i));
            }
        } else {
            for (int i = 0; i < this._count; ++i) {
                this.child(yapReader, i).traverseValues(transaction, visitor4);
            }
        }
    }

    private Object value(YapReader yapReader, int n) {
        if (this._values != null) {
            return this._values[n];
        }
        this.seekValue(yapReader, n);
        return this.valueHandler().readIndexEntry(yapReader);
    }

    private Indexable4 valueHandler() {
        return this._btree._valueHandler;
    }

    public boolean writeObjectBegin() {
        if (this._dead) {
            return false;
        }
        if (this._keys == null) {
            return false;
        }
        return super.writeObjectBegin();
    }

    public void writeThis(Transaction transaction, YapReader yapReader) {
        int n;
        int n2 = 0;
        int n3 = yapReader._offset;
        yapReader.incrementOffset(17);
        if (this._isLeaf) {
            n = this.handlesValues();
            for (int i = 0; i < this._count; ++i) {
                Object object = this.key(transaction, i);
                if (object == No4.INSTANCE) continue;
                ++n2;
                this.keyHandler().writeIndexEntry(yapReader, object);
                if (n == 0) continue;
                this.valueHandler().writeIndexEntry(yapReader, this._values[i]);
            }
        } else {
            for (n = 0; n < this._count; ++n) {
                if (this.childCanSupplyFirstKey(n)) {
                    BTreeNode bTreeNode = (BTreeNode)this._children[n];
                    Object object = bTreeNode.firstKey(transaction);
                    if (object == No4.INSTANCE) continue;
                    ++n2;
                    this.keyHandler().writeIndexEntry(yapReader, object);
                    yapReader.writeIDOf(transaction, bTreeNode);
                    continue;
                }
                ++n2;
                this.keyHandler().writeIndexEntry(yapReader, this.key(n));
                yapReader.writeIDOf(transaction, this._children[n]);
            }
        }
        n = yapReader._offset;
        yapReader._offset = n3;
        yapReader.writeInt(n2);
        yapReader.append(this._isLeaf ? (byte)1 : 0);
        yapReader.writeInt(this._parentID);
        yapReader.writeInt(this._previousID);
        yapReader.writeInt(this._nextID);
        yapReader._offset = n;
    }

    public String toString() {
        if (this._count == 0) {
            return "Node not loaded";
        }
        String string = "\nBTreeNode";
        string = string + "\nid: " + this.getID();
        string = string + "\nparent: " + this._parentID;
        string = string + "\nprevious: " + this._previousID;
        string = string + "\nnext: " + this._nextID;
        string = string + "\ncount:" + this._count;
        string = string + "\nleaf:" + this._isLeaf + "\n";
        if (this._keys != null) {
            string = string + " { ";
            boolean bl = true;
            for (int i = 0; i < this._count; ++i) {
                if (this._keys[i] == null) continue;
                if (!bl) {
                    string = string + ", ";
                }
                string = string + this._keys[i].toString();
                bl = false;
            }
            string = string + " }";
        }
        return string;
    }
}

