/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.network;

import com.db4o.Platform4;
import com.db4o.foundation.network.YapSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class YapSocketReal
implements YapSocket {
    private Socket _socket;
    private OutputStream _out;
    private InputStream _in;
    private String _hostName;

    public YapSocketReal(String string, int n) throws IOException {
        this(new Socket(string, n));
        this._hostName = string;
    }

    public YapSocketReal(Socket socket) throws IOException {
        this._socket = socket;
        this._out = this._socket.getOutputStream();
        this._in = this._socket.getInputStream();
    }

    public void close() throws IOException {
        this._socket.close();
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public boolean isConnected() {
        return Platform4.isConnected(this._socket);
    }

    public int read() throws IOException {
        return this._in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this._in.read(byArray, n, n2);
    }

    public void setSoTimeout(int n) {
        try {
            this._socket.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this._out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this._out.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this._out.write(n);
    }

    public YapSocket openParalellSocket() throws IOException {
        if (this._hostName == null) {
            throw new IOException("Cannot open parallel socket - invalid state.");
        }
        return new YapSocketReal(this._hostName, this._socket.getPort());
    }
}

