/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.config.annotations.reflect;

import com.db4o.Config4Class;
import com.db4o.config.Configuration;
import com.db4o.config.annotations.Indexed;
import com.db4o.config.annotations.reflect.Db4oConfigurator;
import com.db4o.config.annotations.reflect.Db4oConfiguratorFactory;
import com.db4o.config.annotations.reflect.IndexedConfigurator;
import com.db4o.config.annotations.reflect.NoArgsFieldConfiguratorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationIntrospector {
    Map<Class<? extends Annotation>, Db4oConfiguratorFactory> _configurators;
    Config4Class _classConfig;
    Class _clazz;
    Configuration _config;

    public ConfigurationIntrospector(Class clazz, Configuration configuration, Config4Class config4Class) throws Exception {
        this._classConfig = config4Class;
        this._clazz = clazz;
        this._config = configuration;
        this.initMap();
    }

    private void initMap() throws NoSuchMethodException {
        this._configurators = new HashMap<Class<? extends Annotation>, Db4oConfiguratorFactory>();
        this._configurators.put(Indexed.class, new NoArgsFieldConfiguratorFactory(IndexedConfigurator.class));
    }

    public Config4Class apply() {
        try {
            this.reflectFields();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return this._classConfig;
    }

    private void reflectClass() {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = this._clazz.getAnnotations()) {
            this.applyAnnotation(this._clazz, annotation);
        }
    }

    private void reflectFields() {
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = this._clazz.getDeclaredFields()) {
                for (Annotation annotation : field.getAnnotations()) {
                    this.applyAnnotation(field, annotation);
                }
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    private void applyAnnotation(AnnotatedElement annotatedElement, Annotation annotation) {
        if (this._configurators.containsKey(annotation.annotationType())) {
            Db4oConfigurator db4oConfigurator = this._configurators.get(annotation.annotationType()).configuratorFor(annotatedElement, annotation);
            this._classConfig = (Config4Class)db4oConfigurator.configure(this._config);
        }
    }
}

