/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.jdk;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.Platform4;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.ReflectMethod;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.core.ConstructorSupport;
import com.db4o.reflect.core.ReflectConstructor;
import com.db4o.reflect.core.ReflectConstructorSpec;
import com.db4o.reflect.jdk.JavaReflectClass;
import com.db4o.reflect.jdk.JdkConstructor;
import com.db4o.reflect.jdk.JdkField;
import com.db4o.reflect.jdk.JdkMethod;
import com.db4o.reflect.jdk.JdkReflector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkClass
implements JavaReflectClass {
    protected final Reflector _reflector;
    private final JdkReflector _jdkReflector;
    private final Class<?> _clazz;
    private ReflectConstructorSpec _constructorSpec;

    public JdkClass(Reflector reflector, JdkReflector jdkReflector, Class<?> clazz) {
        if (jdkReflector == null) {
            throw new ArgumentNullException();
        }
        if (reflector == null) {
            throw new ArgumentNullException();
        }
        this._reflector = reflector;
        this._clazz = clazz;
        this._jdkReflector = jdkReflector;
        this._constructorSpec = ReflectConstructorSpec.UNSPECIFIED_CONSTRUCTOR;
    }

    @Override
    public ReflectClass getComponentType() {
        return this._reflector.forClass(this._clazz.getComponentType());
    }

    private ReflectConstructor[] getDeclaredConstructors() {
        if (!this._jdkReflector.configuration().testConstructors()) {
            return null;
        }
        try {
            Constructor<?>[] constructors = this._clazz.getDeclaredConstructors();
            ReflectConstructor[] reflectors = new ReflectConstructor[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                reflectors[i] = new JdkConstructor(this._reflector, constructors[i]);
            }
            return reflectors;
        }
        catch (NoClassDefFoundError exc) {
            return new ReflectConstructor[0];
        }
    }

    @Override
    public ReflectField getDeclaredField(String name) {
        try {
            return this.createField(this._clazz.getDeclaredField(name));
        }
        catch (Exception e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    protected JdkField createField(Field field) {
        return new JdkField(this._reflector, field);
    }

    @Override
    public ReflectField[] getDeclaredFields() {
        try {
            Field[] fields = this._clazz.getDeclaredFields();
            ReflectField[] reflectors = new ReflectField[fields.length];
            for (int i = 0; i < reflectors.length; ++i) {
                reflectors[i] = this.createField(fields[i]);
            }
            return reflectors;
        }
        catch (NoClassDefFoundError exc) {
            return new ReflectField[0];
        }
    }

    @Override
    public ReflectClass getDelegate() {
        return this;
    }

    @Override
    public ReflectMethod getMethod(String methodName, ReflectClass[] paramClasses) {
        Class[] nativeParamClasses = JdkReflector.toNative(paramClasses);
        try {
            Method method = this.getNativeMethod(methodName, nativeParamClasses);
            return method == null ? null : new JdkMethod(method, this.reflector());
        }
        catch (Exception e) {
            return null;
        }
    }

    private Method getNativeMethod(String methodName, Class<?>[] paramClasses) {
        for (Class<?> clazz = this._clazz; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredMethod(methodName, paramClasses);
            }
            catch (NoSuchMethodException exc) {
                continue;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this._clazz.getName();
    }

    @Override
    public ReflectClass getSuperclass() {
        return this._reflector.forClass(this._clazz.getSuperclass());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this._clazz.getModifiers());
    }

    @Override
    public boolean isArray() {
        return this._clazz.isArray();
    }

    @Override
    public boolean isAssignableFrom(ReflectClass type) {
        if (!(type instanceof JavaReflectClass)) {
            return false;
        }
        return this._clazz.isAssignableFrom(JdkReflector.toNative(type));
    }

    @Override
    public boolean isCollection() {
        return this._reflector.isCollection(this);
    }

    @Override
    public boolean isInstance(Object obj) {
        return this._clazz.isInstance(obj);
    }

    @Override
    public boolean isInterface() {
        return this._clazz.isInterface();
    }

    @Override
    public boolean isPrimitive() {
        return this._clazz.isPrimitive();
    }

    @Override
    public Object newInstance() {
        return this.constructorSpec().newInstance();
    }

    @Override
    public Class<?> getJavaClass() {
        return this._clazz;
    }

    @Override
    public Reflector reflector() {
        return this._reflector;
    }

    @Override
    public ReflectConstructor getSerializableConstructor() {
        return Platform4.jdk().serializableConstructor(this._reflector, this._clazz);
    }

    @Override
    public Object nullValue() {
        return this._jdkReflector.nullValue(this);
    }

    private ReflectConstructorSpec constructorSpec() {
        if (this._constructorSpec.canBeInstantiated().isUnspecified()) {
            this._constructorSpec = ConstructorSupport.createConstructor(this, this._clazz, this._jdkReflector.configuration(), this.getDeclaredConstructors());
        }
        return this._constructorSpec;
    }

    @Override
    public boolean ensureCanBeInstantiated() {
        return this.constructorSpec().canBeInstantiated().definiteYes();
    }

    @Override
    public boolean isImmutable() {
        return this.isPrimitive() || Platform4.isSimple(this._clazz);
    }
}

