/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.qlin;

import com.db4o.foundation.Function4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.IdentityHashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.foundation.Pair;
import com.db4o.foundation.Procedure4;
import com.db4o.internal.Platform4;
import com.db4o.qlin.PrototypesException;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.core.ReflectorUtils;
import com.db4o.reflect.generic.GenericReflector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prototypes {
    private final Reflector _reflector;
    private final Hashtable4 _prototypes = new Hashtable4();
    private final boolean _ignoreTransient;
    private final int _recursionDepth;
    private static Hashtable4 _integerConverters;
    private static final String STRING_IDENTIFIER = "QLinIdentity";

    public Prototypes(Reflector reflector, int recursionDepth, boolean ignoreTransient) {
        this._reflector = reflector;
        this._recursionDepth = recursionDepth;
        this._ignoreTransient = ignoreTransient;
    }

    public Prototypes() {
        this(Prototypes.defaultReflector(), 5, false);
    }

    public <T> T prototypeForClass(Class<T> clazz) {
        if (clazz == null) {
            throw new PrototypesException("Class can not be null");
        }
        ReflectClass claxx = this._reflector.forClass(clazz);
        if (claxx == null) {
            throw new PrototypesException("Not found in the reflector: " + clazz);
        }
        String className = claxx.getName();
        Prototype prototype = (Prototype)this._prototypes.get(className);
        if (prototype != null) {
            return prototype.object();
        }
        prototype = new Prototype(claxx);
        this._prototypes.put(className, prototype);
        return prototype.object();
    }

    public <T> Iterator4<String> backingFieldPath(Class<T> clazz, Object expression) {
        return this.backingFieldPath(this._reflector.forClass(clazz), expression);
    }

    public <T> Iterator4<String> backingFieldPath(ReflectClass claxx, Object expression) {
        return this.backingFieldPath(claxx.getName(), expression);
    }

    public <T> Iterator4<String> backingFieldPath(String className, Object expression) {
        Prototype prototype = (Prototype)this._prototypes.get(className);
        if (prototype == null) {
            return null;
        }
        return prototype.backingFieldPath(this._reflector, expression);
    }

    private static IntegerConverter integerConverterforClassName(Reflector reflector, String className) {
        if (_integerConverters == null) {
            IntegerConverter[] converters;
            _integerConverters = new Hashtable4();
            for (IntegerConverter converter : converters = new IntegerConverter[]{new IntegerConverter(){

                public String primitiveName() {
                    return Integer.TYPE.getName();
                }

                public Object fromInteger(int i) {
                    return new Integer(i);
                }
            }, new IntegerConverter(){

                public String primitiveName() {
                    return Long.TYPE.getName();
                }

                public Object fromInteger(int i) {
                    return new Long(i);
                }
            }, new IntegerConverter(){

                public String primitiveName() {
                    return Double.TYPE.getName();
                }

                public Object fromInteger(int i) {
                    return new Double(i);
                }
            }, new IntegerConverter(){

                public String primitiveName() {
                    return Float.TYPE.getName();
                }

                public Object fromInteger(int i) {
                    return new Float(i);
                }
            }, new IntegerConverter(){

                public String primitiveName() {
                    return Byte.TYPE.getName();
                }

                public Object fromInteger(int i) {
                    return new Byte((byte)i);
                }
            }, new IntegerConverter(){

                public String primitiveName() {
                    return Character.TYPE.getName();
                }

                public Object fromInteger(int i) {
                    return new Character((char)i);
                }
            }, new IntegerConverter(){

                public String primitiveName() {
                    return Short.TYPE.getName();
                }

                public Object fromInteger(int i) {
                    return new Short((short)i);
                }
            }, new IntegerConverter(){

                public String primitiveName() {
                    return String.class.getName();
                }

                public Object fromInteger(int i) {
                    return Prototypes.STRING_IDENTIFIER + i;
                }

                public int toInteger(Object obj) {
                    if (!(obj instanceof String)) {
                        return -1;
                    }
                    String str = (String)obj;
                    if (str.length() < Prototypes.STRING_IDENTIFIER.length()) {
                        return -1;
                    }
                    if (str.indexOf(Prototypes.STRING_IDENTIFIER) != 0) {
                        return -1;
                    }
                    return Integer.parseInt(str.substring(Prototypes.STRING_IDENTIFIER.length()));
                }
            }}) {
                _integerConverters.put(converter.primitiveName(), (Object)converter);
                if (converter.primitiveName().equals(converter.wrapperName(reflector))) continue;
                _integerConverters.put(converter.wrapperName(reflector), (Object)converter);
            }
        }
        return (IntegerConverter)_integerConverters.get(className);
    }

    public Reflector reflector() {
        return this._reflector;
    }

    public static Reflector defaultReflector() {
        return new GenericReflector(Platform4.reflectorForType(Prototypes.class));
    }

    private static boolean trySetField(ReflectField field, Object onObject, Object value) {
        try {
            field.set(onObject, value);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class IntegerConverter<T> {
        private IntegerConverter() {
        }

        public String wrapperName(Reflector reflector) {
            return reflector.forObject(this.fromInteger(1)).getName();
        }

        public abstract String primitiveName();

        public abstract T fromInteger(int var1);

        public int toInteger(T obj) {
            return Integer.parseInt(obj.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Prototype<T> {
        private final IdentityHashtable4 _fieldsByIdentity = new IdentityHashtable4();
        private final Hashtable4 _fieldsByIntId = new Hashtable4();
        private final T _object;
        private int intIdGenerator;

        public Prototype(ReflectClass claxx) {
            this._object = claxx.newInstance();
            if (this._object == null) {
                throw new PrototypesException("Prototype could not be created for class " + claxx.getName());
            }
            this.analyze(this._object, claxx, Prototypes.this._recursionDepth, null);
        }

        private void analyze(final Object object, final ReflectClass claxx, final int depth, final List4 parentPath) {
            if (depth < 0) {
                return;
            }
            ReflectorUtils.forEachField(claxx, new Procedure4<ReflectField>(){

                @Override
                public void apply(ReflectField field) {
                    if (field.isStatic()) {
                        return;
                    }
                    if (Prototypes.this._ignoreTransient && field.isTransient()) {
                        return;
                    }
                    ReflectClass fieldType = field.getFieldType();
                    List4<ReflectField> path = new List4<ReflectField>(parentPath, field);
                    IntegerConverter converter = Prototypes.integerConverterforClassName(claxx.reflector(), fieldType.getName());
                    if (converter != null) {
                        int id = ++Prototype.this.intIdGenerator;
                        Object integerRepresentation = converter.fromInteger(id);
                        if (!Prototypes.trySetField(field, object, integerRepresentation)) {
                            return;
                        }
                        Prototype.this._fieldsByIntId.put(id, (Object)new Pair(integerRepresentation, path));
                        return;
                    }
                    if (!fieldType.isPrimitive()) {
                        Object identityInstance = fieldType.newInstance();
                        if (identityInstance == null) {
                            return;
                        }
                        if (!Prototypes.trySetField(field, object, identityInstance)) {
                            return;
                        }
                        Prototype.this._fieldsByIdentity.put(identityInstance, path);
                        Prototype.this.analyze(identityInstance, claxx, depth - 1, path);
                    }
                }
            });
        }

        public T object() {
            return this._object;
        }

        public Iterator4<String> backingFieldPath(Reflector reflector, Object expression) {
            if (expression == null) {
                return null;
            }
            ReflectClass claxx = reflector.forObject(expression);
            if (claxx == null) {
                return null;
            }
            IntegerConverter converter = Prototypes.integerConverterforClassName(reflector, claxx.getName());
            if (converter != null) {
                Pair entry = (Pair)this._fieldsByIntId.get(converter.toInteger(expression));
                if (entry == null) {
                    return null;
                }
                if (entry.first.equals(expression)) {
                    return this.asIterator((List4)entry.second);
                }
                return null;
            }
            if (claxx.isPrimitive()) {
                return null;
            }
            return this.asIterator((List4)this._fieldsByIdentity.get(expression));
        }

        private Iterator4<String> asIterator(List4 lastElement) {
            return Iterators.revert(Iterators.map(Iterators.iterate(lastElement), (Function4)new Function4<ReflectField, String>(){

                @Override
                public String apply(ReflectField field) {
                    return field.getName();
                }
            }));
        }
    }
}

