/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.instrumentation;

import com.db4o.instrumentation.api.MethodBuilder;
import com.db4o.instrumentation.api.MethodRef;
import com.db4o.instrumentation.api.TypeRef;
import com.db4o.nativequery.expr.cmp.operand.ArithmeticExpression;
import com.db4o.nativequery.expr.cmp.operand.ArrayAccessValue;
import com.db4o.nativequery.expr.cmp.operand.CandidateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperand;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandVisitor;
import com.db4o.nativequery.expr.cmp.operand.ConstValue;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import com.db4o.nativequery.expr.cmp.operand.MethodCallValue;
import com.db4o.nativequery.expr.cmp.operand.PredicateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.StaticFieldRoot;
import com.db4o.nativequery.instrumentation.TypeDeducingVisitor;

class ComparisonBytecodeGeneratingVisitor
implements ComparisonOperandVisitor {
    private MethodBuilder _methodBuilder;
    private TypeRef _predicateClass;
    private boolean _inArithmetic = false;
    private TypeRef _opClass = null;
    private TypeRef _staticRoot = null;

    public ComparisonBytecodeGeneratingVisitor(MethodBuilder methodBuilder, TypeRef predicateClass) {
        this._methodBuilder = methodBuilder;
        this._predicateClass = predicateClass;
    }

    public void visit(ConstValue operand) {
        Object value = operand.value();
        if (value != null) {
            this._opClass = this.typeRef(value.getClass());
        }
        this._methodBuilder.ldc(value);
        if (value != null) {
            this.box(this._opClass, !this._inArithmetic);
        }
    }

    private TypeRef typeRef(Class type) {
        return this._methodBuilder.references().forType(type);
    }

    public void visit(FieldValue fieldValue) {
        TypeRef lastFieldClass = fieldValue.field().type();
        boolean needConversion = lastFieldClass.isPrimitive();
        fieldValue.parent().accept(this);
        if (this._staticRoot != null) {
            this._methodBuilder.loadStaticField(fieldValue.field());
            this._staticRoot = null;
            return;
        }
        this._methodBuilder.loadField(fieldValue.field());
        this.box(lastFieldClass, !this._inArithmetic && needConversion);
    }

    public void visit(CandidateFieldRoot root) {
        this._methodBuilder.loadArgument(1);
    }

    public void visit(PredicateFieldRoot root) {
        this._methodBuilder.loadArgument(0);
    }

    public void visit(StaticFieldRoot root) {
        this._staticRoot = root.type();
    }

    public void visit(ArrayAccessValue operand) {
        TypeRef cmpType = this.deduceFieldClass(operand.parent()).elementType();
        operand.parent().accept(this);
        boolean outerInArithmetic = this._inArithmetic;
        this._inArithmetic = true;
        operand.index().accept(this);
        this._inArithmetic = outerInArithmetic;
        this._methodBuilder.loadArrayElement(cmpType);
        this.box(cmpType, !this._inArithmetic);
    }

    public void visit(MethodCallValue operand) {
        MethodRef method = operand.method();
        TypeRef retType = method.returnType();
        boolean needConversion = retType.isPrimitive();
        operand.parent().accept(this);
        boolean oldInArithmetic = this._inArithmetic;
        for (int paramIdx = 0; paramIdx < operand.args().length; ++paramIdx) {
            this._inArithmetic = operand.method().paramTypes()[paramIdx].isPrimitive();
            operand.args()[paramIdx].accept(this);
        }
        this._inArithmetic = oldInArithmetic;
        this._methodBuilder.invoke(method, operand.callingConvention());
        this.box(retType, !this._inArithmetic && needConversion);
    }

    public void visit(ArithmeticExpression operand) {
        boolean oldInArithmetic = this._inArithmetic;
        this._inArithmetic = true;
        operand.left().accept(this);
        operand.right().accept(this);
        TypeRef operandType = this.arithmeticType(operand);
        switch (operand.op().id()) {
            case 0: {
                this._methodBuilder.add(operandType);
                break;
            }
            case 1: {
                this._methodBuilder.subtract(operandType);
                break;
            }
            case 2: {
                this._methodBuilder.multiply(operandType);
                break;
            }
            case 3: {
                this._methodBuilder.divide(operandType);
                break;
            }
            case 4: {
                this._methodBuilder.modulo(operandType);
                break;
            }
            default: {
                throw new RuntimeException("Unknown operand: " + operand.op());
            }
        }
        this.box(this._opClass, !oldInArithmetic);
        this._inArithmetic = oldInArithmetic;
    }

    private void box(TypeRef boxedType, boolean canApply) {
        if (!canApply) {
            return;
        }
        this._methodBuilder.box(boxedType);
    }

    private TypeRef deduceFieldClass(ComparisonOperand fieldValue) {
        TypeDeducingVisitor visitor = new TypeDeducingVisitor(this._methodBuilder.references(), this._predicateClass);
        fieldValue.accept(visitor);
        return visitor.operandClass();
    }

    private TypeRef arithmeticType(ComparisonOperand operand) {
        if (operand instanceof ConstValue) {
            return this.primitiveType(((ConstValue)operand).value().getClass());
        }
        if (operand instanceof FieldValue) {
            return ((FieldValue)operand).field().type();
        }
        if (operand instanceof ArithmeticExpression) {
            ArithmeticExpression expr = (ArithmeticExpression)operand;
            TypeRef left = this.arithmeticType(expr.left());
            TypeRef right = this.arithmeticType(expr.right());
            if (left == this.doubleType() || right == this.doubleType()) {
                return this.doubleType();
            }
            if (left == this.floatType() || right == this.floatType()) {
                return this.floatType();
            }
            if (left == this.longType() || right == this.longType()) {
                return this.longType();
            }
            return this.intType();
        }
        return null;
    }

    private TypeRef primitiveType(Class klass) {
        if (klass == Integer.class || klass == Short.class || klass == Boolean.class || klass == Byte.class) {
            return this.intType();
        }
        if (klass == Double.class) {
            return this.doubleType();
        }
        if (klass == Float.class) {
            return this.floatType();
        }
        if (klass == Long.class) {
            return this.longType();
        }
        return this.typeRef(klass);
    }

    private TypeRef intType() {
        return this.typeRef(Integer.TYPE);
    }

    private TypeRef longType() {
        return this.typeRef(Long.TYPE);
    }

    private TypeRef floatType() {
        return this.typeRef(Float.TYPE);
    }

    private TypeRef doubleType() {
        return this.typeRef(Double.TYPE);
    }
}

