/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.expr.build;

import com.db4o.nativequery.expr.AndExpression;
import com.db4o.nativequery.expr.BoolConstExpression;
import com.db4o.nativequery.expr.ComparisonExpression;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.NotExpression;
import com.db4o.nativequery.expr.OrExpression;
import com.db4o.nativequery.expr.cmp.operand.ConstValue;

public class ExpressionBuilder {
    public Expression not(Expression expr) {
        ConstValue rightConst;
        ComparisonExpression cmpExpr;
        if (expr.equals(BoolConstExpression.TRUE)) {
            return BoolConstExpression.FALSE;
        }
        if (expr.equals(BoolConstExpression.FALSE)) {
            return BoolConstExpression.TRUE;
        }
        if (expr instanceof NotExpression) {
            return ((NotExpression)expr).expr();
        }
        if (expr instanceof ComparisonExpression && (cmpExpr = (ComparisonExpression)expr).right() instanceof ConstValue && (rightConst = (ConstValue)cmpExpr.right()).value() instanceof Boolean) {
            Boolean boolVal = (Boolean)rightConst.value();
            return new ComparisonExpression(cmpExpr.left(), new ConstValue(new Boolean(boolVal == false)), cmpExpr.op());
        }
        return new NotExpression(expr);
    }

    public Expression and(Expression left, Expression right) {
        if (left.equals(BoolConstExpression.FALSE) || right.equals(BoolConstExpression.FALSE)) {
            return BoolConstExpression.FALSE;
        }
        if (left.equals(BoolConstExpression.TRUE)) {
            return right;
        }
        if (right.equals(BoolConstExpression.TRUE)) {
            return left;
        }
        if (left.equals(right)) {
            return left;
        }
        if (this.negatives(left, right)) {
            return BoolConstExpression.FALSE;
        }
        return new AndExpression(left, right);
    }

    public Expression or(Expression left, Expression right) {
        if (left.equals(BoolConstExpression.TRUE) || right.equals(BoolConstExpression.TRUE)) {
            return BoolConstExpression.TRUE;
        }
        if (left.equals(BoolConstExpression.FALSE)) {
            return right;
        }
        if (right.equals(BoolConstExpression.FALSE)) {
            return left;
        }
        if (left.equals(right)) {
            return left;
        }
        if (this.negatives(left, right)) {
            return BoolConstExpression.TRUE;
        }
        return new OrExpression(left, right);
    }

    public BoolConstExpression constant(Boolean value) {
        return BoolConstExpression.expr(value);
    }

    public Expression ifThenElse(Expression cond, Expression truePath, Expression falsePath) {
        Expression expr = this.checkBoolean(cond, truePath, falsePath);
        if (expr != null) {
            return expr;
        }
        return this.or(this.and(cond, truePath), this.and(this.not(cond), falsePath));
    }

    private Expression checkBoolean(Expression cmp, Expression trueExpr, Expression falseExpr) {
        Expression swap;
        if (cmp instanceof BoolConstExpression) {
            return null;
        }
        if (trueExpr instanceof BoolConstExpression) {
            boolean leftNegative = trueExpr.equals(BoolConstExpression.FALSE);
            if (!leftNegative) {
                return this.or(cmp, falseExpr);
            }
            return this.and(this.not(cmp), falseExpr);
        }
        if (falseExpr instanceof BoolConstExpression) {
            boolean rightNegative = falseExpr.equals(BoolConstExpression.FALSE);
            if (!rightNegative) {
                return this.and(cmp, trueExpr);
            }
            return this.or(this.not(cmp), falseExpr);
        }
        if (cmp instanceof NotExpression) {
            cmp = ((NotExpression)cmp).expr();
            Expression swap2 = trueExpr;
            trueExpr = falseExpr;
            falseExpr = swap2;
        }
        if (trueExpr instanceof OrExpression) {
            OrExpression orExpr = (OrExpression)trueExpr;
            Expression orLeft = orExpr.left();
            Expression orRight = orExpr.right();
            if (falseExpr.equals(orRight)) {
                swap = orRight;
                orRight = orLeft;
                orLeft = swap;
            }
            if (falseExpr.equals(orLeft)) {
                return this.or(orLeft, this.and(cmp, orRight));
            }
        }
        if (falseExpr instanceof AndExpression) {
            AndExpression andExpr = (AndExpression)falseExpr;
            Expression andLeft = andExpr.left();
            Expression andRight = andExpr.right();
            if (trueExpr.equals(andRight)) {
                swap = andRight;
                andRight = andLeft;
                andLeft = swap;
            }
            if (trueExpr.equals(andLeft)) {
                return this.and(andLeft, this.or(cmp, andRight));
            }
        }
        return null;
    }

    private boolean negatives(Expression left, Expression right) {
        return this.negativeOf(left, right) || this.negativeOf(right, left);
    }

    private boolean negativeOf(Expression right, Expression left) {
        return right instanceof NotExpression && ((NotExpression)right).expr().equals(left);
    }
}

