/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.analysis;

import com.db4o.nativequery.analysis.TypeRefUtil;
import com.db4o.nativequery.expr.ComparisonExpression;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.expr.build.ExpressionBuilder;
import com.db4o.nativequery.expr.cmp.ComparisonOperator;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperand;
import com.db4o.nativequery.expr.cmp.operand.ConstValue;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import java.util.HashMap;
import java.util.Map;

public class ComparisonExpressionFactory {
    private final ExpressionBuilder _expBuilder;
    private final Map _builders = new HashMap();

    public ComparisonExpressionFactory(ExpressionBuilder expBuilder) {
        this._expBuilder = expBuilder;
        this._builders.put(new BuilderSpec(0, false), new PlainComparisonBuilder(ComparisonOperator.REFERENCE_EQUALITY));
        this._builders.put(new BuilderSpec(0, true), new PlainComparisonBuilder(ComparisonOperator.VALUE_EQUALITY));
        this._builders.put(new BuilderSpec(1, false), new NegateComparisonBuilder(ComparisonOperator.REFERENCE_EQUALITY));
        this._builders.put(new BuilderSpec(1, true), new NegateComparisonBuilder(ComparisonOperator.VALUE_EQUALITY));
        this._builders.put(new BuilderSpec(4, false), new PlainComparisonBuilder(ComparisonOperator.SMALLER));
        this._builders.put(new BuilderSpec(4, true), this.builder(4, false));
        this._builders.put(new BuilderSpec(2, false), new PlainComparisonBuilder(ComparisonOperator.GREATER));
        this._builders.put(new BuilderSpec(2, true), this.builder(2, false));
        this._builders.put(new BuilderSpec(5, false), new NegateComparisonBuilder(ComparisonOperator.GREATER));
        this._builders.put(new BuilderSpec(5, true), this.builder(5, false));
        this._builders.put(new BuilderSpec(3, false), new NegateComparisonBuilder(ComparisonOperator.SMALLER));
        this._builders.put(new BuilderSpec(3, true), this.builder(3, false));
    }

    public Expression buildComparison(int op, boolean isPrimitive, FieldValue fieldExpr, ComparisonOperand valueExpr) {
        return this.builder(op, isPrimitive).buildComparison(fieldExpr, valueExpr);
    }

    private PlainComparisonBuilder builder(int op, boolean primitive) {
        return (PlainComparisonBuilder)this._builders.get(new BuilderSpec(op, primitive));
    }

    private class NegateComparisonBuilder
    extends PlainComparisonBuilder {
        public NegateComparisonBuilder(ComparisonOperator op) {
            super(op);
        }

        public Expression buildComparison(FieldValue fieldValue, ComparisonOperand valueExpr) {
            return ComparisonExpressionFactory.this._expBuilder.not(super.buildComparison(fieldValue, valueExpr));
        }
    }

    private static class PlainComparisonBuilder {
        private ComparisonOperator op;

        public PlainComparisonBuilder(ComparisonOperator op) {
            this.op = op;
        }

        public Expression buildComparison(FieldValue fieldValue, ComparisonOperand valueExpr) {
            ConstValue constValue;
            if (TypeRefUtil.isBooleanField(fieldValue) && valueExpr instanceof ConstValue && (constValue = (ConstValue)valueExpr).value() instanceof Integer) {
                Integer intValue = (Integer)constValue.value();
                Boolean boolValue = intValue == 0 ? Boolean.FALSE : Boolean.TRUE;
                valueExpr = new ConstValue(boolValue);
            }
            return new ComparisonExpression(fieldValue, valueExpr, this.op);
        }
    }

    private static class BuilderSpec {
        private int _op;
        private boolean _primitive;

        public BuilderSpec(int op, boolean primitive) {
            this._op = op;
            this._primitive = primitive;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this._op;
            result = 31 * result + (this._primitive ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BuilderSpec other = (BuilderSpec)obj;
            if (this._op != other._op) {
                return false;
            }
            return this._primitive == other._primitive;
        }
    }
}

