/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.foundation.Environments;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.BinDecorator;
import com.db4o.io.Storage;
import com.db4o.io.StorageDecorator;
import com.db4o.monitoring.Db4oMBeans;
import com.db4o.monitoring.IO;

public class MonitoredStorage
extends StorageDecorator {
    public MonitoredStorage(Storage storage) {
        super(storage);
    }

    protected Bin decorate(BinConfiguration config, Bin bin) {
        return new MonitoredBin(config.uri(), bin);
    }

    private static class MonitoredBin
    extends BinDecorator {
        private IO _ioMBean = Db4oMBeans.newIOStatsMBean(Environments.my(ObjectContainer.class));

        public MonitoredBin(String uri, Bin bin) {
            super(bin);
        }

        public void sync() {
            super.sync();
            this._ioMBean.notifySync();
        }

        public void sync(Runnable runnable) {
            super.sync(runnable);
            this._ioMBean.notifySync();
        }

        public int read(long position, byte[] bytes, int bytesToRead) {
            int bytesRead = super.read(position, bytes, bytesToRead);
            this._ioMBean.notifyBytesRead(bytesRead);
            return bytesRead;
        }

        public int syncRead(long position, byte[] bytes, int bytesToRead) {
            int bytesRead = super.syncRead(position, bytes, bytesToRead);
            this._ioMBean.notifyBytesRead(bytesRead);
            return bytesRead;
        }

        public void write(long position, byte[] bytes, int bytesToWrite) {
            super.write(position, bytes, bytesToWrite);
            this._ioMBean.notifyBytesWritten(bytesToWrite);
        }
    }
}

