/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.io.IoAdapter;
import com.db4o.io.RandomAccessFileAdapter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SymbianIoAdapter
extends RandomAccessFileAdapter {
    private byte[] _seekBytes = new byte[500];
    private String _path;
    private long _pos;
    private long _length;

    protected SymbianIoAdapter(String path, boolean lockFile, long initialLength, boolean readOnly) throws Db4oIOException {
        super(path, lockFile, initialLength, readOnly);
        this._path = path;
        this._pos = 0L;
        this.setLength();
    }

    private void setLength() throws Db4oIOException {
        this._length = this.retrieveLength();
    }

    private long retrieveLength() throws Db4oIOException {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(this._path, "r");
            long l = file.length();
            return l;
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                throw new Db4oIOException(e);
            }
        }
    }

    public SymbianIoAdapter() {
    }

    public IoAdapter open(String path, boolean lockFile, long initialLength, boolean readOnly) throws Db4oIOException {
        return new SymbianIoAdapter(path, lockFile, initialLength, readOnly);
    }

    public long getLength() throws Db4oIOException {
        this.setLength();
        return this._length;
    }

    public int read(byte[] bytes, int length) throws Db4oIOException {
        int ret = super.read(bytes, length);
        this._pos += (long)ret;
        return ret;
    }

    public void write(byte[] buffer, int length) throws Db4oIOException {
        super.write(buffer, length);
        this._pos += (long)length;
        if (this._pos > this._length) {
            this.setLength();
        }
    }

    public void seek(long pos) throws Db4oIOException {
        if (pos > this._length) {
            this.setLength();
        }
        if (pos > this._length) {
            int len = (int)(pos - this._length);
            super.seek(this._length);
            this._pos = this._length;
            if (len < 500) {
                this.write(this._seekBytes, len);
            } else {
                this.write(new byte[len]);
            }
        }
        super.seek(pos);
        this._pos = pos;
    }
}

