/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.io.File4;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.Storage;
import com.db4o.io.StorageDecorator;

public class SaveAsStorage
extends StorageDecorator {
    private final Hashtable4 _binRecords = new Hashtable4();

    public SaveAsStorage(Storage storage) {
        super(storage);
    }

    public void saveAs(final String oldUri, final String newUri) {
        if (File4.exists(newUri)) {
            throw new IllegalStateException(newUri + " already exists");
        }
        BinRecord binRecord = (BinRecord)this._binRecords.get(oldUri);
        if (binRecord == null) {
            throw new IllegalStateException(oldUri + " was never opened or was closed.");
        }
        final BinConfiguration oldConfiguration = binRecord._binConfiguration;
        final SaveAsBin saveAsBin = binRecord._bin;
        Runnable closure = new Runnable(){

            public void run() {
                saveAsBin.sync();
                saveAsBin.close();
                try {
                    File4.copy(oldUri, newUri);
                }
                catch (Exception e) {
                    SaveAsStorage.this.reopenOldConfiguration(saveAsBin, oldConfiguration, newUri, e);
                }
                BinConfiguration newConfiguration = SaveAsStorage.this.pointToNewUri(oldConfiguration, newUri);
                try {
                    Bin newBin = SaveAsStorage.this._storage.open(newConfiguration);
                    saveAsBin.delegateTo(newBin);
                    SaveAsStorage.this._binRecords.remove(oldUri);
                    SaveAsStorage.this._binRecords.put(newUri, (Object)new BinRecord(newConfiguration, saveAsBin));
                }
                catch (Exception e) {
                    SaveAsStorage.this.reopenOldConfiguration(saveAsBin, oldConfiguration, newUri, e);
                }
            }
        };
        saveAsBin.exchangeUnderlyingBin(closure);
    }

    private BinConfiguration pointToNewUri(BinConfiguration oldConfig, String newUri) {
        return new BinConfiguration(newUri, oldConfig.lockFile(), oldConfig.initialLength(), oldConfig.readOnly());
    }

    private void reopenOldConfiguration(SaveAsBin saveAsBin, BinConfiguration config, String newUri, Exception e) {
        Bin safeBin = this._storage.open(config);
        saveAsBin.delegateTo(safeBin);
        throw new Db4oException("Copying to " + newUri + " failed. Reopened " + config.uri(), e);
    }

    public Bin open(BinConfiguration config) throws Db4oIOException {
        SaveAsBin openedBin = new SaveAsBin(super.open(config));
        this._binRecords.put(config.uri(), (Object)new BinRecord(config, openedBin));
        return openedBin;
    }

    private static class SaveAsBin
    implements Bin {
        private Bin _bin;

        SaveAsBin(Bin delegate_) {
            this._bin = delegate_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exchangeUnderlyingBin(Runnable closure) {
            SaveAsBin saveAsBin = this;
            synchronized (saveAsBin) {
                closure.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            SaveAsBin saveAsBin = this;
            synchronized (saveAsBin) {
                this._bin.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long length() {
            SaveAsBin saveAsBin = this;
            synchronized (saveAsBin) {
                return this._bin.length();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(long position, byte[] bytes, int bytesToRead) {
            SaveAsBin saveAsBin = this;
            synchronized (saveAsBin) {
                return this._bin.read(position, bytes, bytesToRead);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sync() {
            SaveAsBin saveAsBin = this;
            synchronized (saveAsBin) {
                this._bin.sync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sync(Runnable runnable) {
            SaveAsBin saveAsBin = this;
            synchronized (saveAsBin) {
                this.sync();
                runnable.run();
                this.sync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int syncRead(long position, byte[] bytes, int bytesToRead) {
            SaveAsBin saveAsBin = this;
            synchronized (saveAsBin) {
                return this._bin.syncRead(position, bytes, bytesToRead);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(long position, byte[] bytes, int bytesToWrite) {
            SaveAsBin saveAsBin = this;
            synchronized (saveAsBin) {
                this._bin.write(position, bytes, bytesToWrite);
            }
        }

        public void delegateTo(Bin bin) {
            this._bin = bin;
        }
    }

    private static class BinRecord {
        final SaveAsBin _bin;
        final BinConfiguration _binConfiguration;

        BinRecord(BinConfiguration binConfiguration, SaveAsBin bin) {
            this._binConfiguration = binConfiguration;
            this._bin = bin;
        }
    }
}

