/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.internal.caching.Cache4;
import com.db4o.internal.caching.CacheFactory;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.CachingBin;
import com.db4o.io.ReadOnlyBin;
import com.db4o.io.Storage;
import com.db4o.io.StorageDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingStorage
extends StorageDecorator {
    private static int DEFAULT_PAGE_COUNT = 64;
    private static int DEFAULT_PAGE_SIZE = 1024;
    private int _pageCount;
    private int _pageSize;

    public CachingStorage(Storage storage) {
        this(storage, DEFAULT_PAGE_COUNT, DEFAULT_PAGE_SIZE);
    }

    public CachingStorage(Storage storage, int pageCount, int pageSize) {
        super(storage);
        this._pageCount = pageCount;
        this._pageSize = pageSize;
    }

    @Override
    public Bin open(BinConfiguration config) throws Db4oIOException {
        Bin storage = super.open(config);
        if (config.readOnly()) {
            return new ReadOnlyBin(new NonFlushingCachingBin(storage, this.newCache(), this._pageCount, this._pageSize));
        }
        return new CachingBin(storage, this.newCache(), this._pageCount, this._pageSize);
    }

    protected Cache4<Long, Object> newCache() {
        return CacheFactory.newLRULongCache(this._pageCount);
    }

    private static final class NonFlushingCachingBin
    extends CachingBin {
        public NonFlushingCachingBin(Bin bin, Cache4 cache, int pageCount, int pageSize) throws Db4oIOException {
            super(bin, cache, pageCount, pageSize);
        }

        protected void flushAllPages() {
        }
    }
}

