/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.references;

import com.db4o.DTrace;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.references.ReferenceSystem;

public class HashcodeReferenceSystem
implements ReferenceSystem {
    private ObjectReference _hashCodeTree;
    private ObjectReference _idTree;

    public void addNewReference(ObjectReference ref) {
        this.addReference(ref);
    }

    public void addExistingReference(ObjectReference ref) {
        this.addReference(ref);
    }

    private void addReference(ObjectReference ref) {
        ref.ref_init();
        this.idAdd(ref);
        this.hashCodeAdd(ref);
    }

    public void commit() {
    }

    private void hashCodeAdd(ObjectReference ref) {
        if (this._hashCodeTree == null) {
            this._hashCodeTree = ref;
            return;
        }
        this._hashCodeTree = this._hashCodeTree.hc_add(ref);
    }

    private void idAdd(ObjectReference ref) {
        if (DTrace.enabled) {
            DTrace.ID_TREE_ADD.log(ref.getID());
        }
        if (this._idTree == null) {
            this._idTree = ref;
            return;
        }
        this._idTree = this._idTree.id_add(ref);
    }

    public ObjectReference referenceForId(int id) {
        if (DTrace.enabled) {
            DTrace.GET_YAPOBJECT.log(id);
        }
        if (this._idTree == null) {
            return null;
        }
        if (!ObjectReference.isValidId(id)) {
            return null;
        }
        return this._idTree.id_find(id);
    }

    public ObjectReference referenceForObject(Object obj) {
        if (this._hashCodeTree == null) {
            return null;
        }
        return this._hashCodeTree.hc_find(obj);
    }

    public void removeReference(ObjectReference ref) {
        if (DTrace.enabled) {
            DTrace.REFERENCE_REMOVED.log(ref.getID());
        }
        if (this._hashCodeTree != null) {
            this._hashCodeTree = this._hashCodeTree.hc_remove(ref);
        }
        if (this._idTree != null) {
            this._idTree = this._idTree.id_remove(ref);
        }
    }

    public void rollback() {
    }

    public void traverseReferences(Visitor4 visitor) {
        if (this._hashCodeTree == null) {
            return;
        }
        this._hashCodeTree.hc_traverse(visitor);
    }

    public String toString() {
        final BooleanByRef found = new BooleanByRef();
        final StringBuffer str = new StringBuffer("HashcodeReferenceSystem {");
        this.traverseReferences(new Visitor4(){

            public void visit(Object obj) {
                if (found.value) {
                    str.append(", ");
                }
                ObjectReference ref = (ObjectReference)obj;
                str.append(ref.getID());
                found.value = true;
            }
        });
        str.append("}");
        return str.toString();
    }

    public void discarded() {
    }
}

