/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.query.Db4oEnhancedFilter;
import com.db4o.internal.query.Db4oNQOptimizer;
import com.db4o.internal.query.Db4oQueryExecutionListener;
import com.db4o.internal.query.NQOptimizationInfo;
import com.db4o.internal.query.PredicateEvaluation;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.Reflector;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeQueryHandler {
    private static final String OPTIMIZER_IMPL_NAME = "com.db4o.nativequery.optimization.Db4oOnTheFlyEnhancer";
    public static final String UNOPTIMIZED = "UNOPTIMIZED";
    public static final String PREOPTIMIZED = "PREOPTIMIZED";
    public static final String DYNOPTIMIZED = "DYNOPTIMIZED";
    private ObjectContainer _container;
    private Db4oNQOptimizer _enhancer;
    private List4 _listeners;

    public NativeQueryHandler(ObjectContainer container) {
        this._container = container;
        this.loadQueryOptimizer();
    }

    public void addListener(Db4oQueryExecutionListener listener) {
        this._listeners = new List4<Db4oQueryExecutionListener>(this._listeners, listener);
    }

    public void clearListeners() {
        this._listeners = null;
    }

    public <T> ObjectSet<T> execute(Query query, Predicate<T> predicate, QueryComparator<T> comparator) {
        return this.configureQuery(query, predicate, comparator).execute();
    }

    private Query configureQuery(Query query, Predicate predicate, QueryComparator comparator) {
        DiagnosticProcessor dp;
        if (comparator != null) {
            query.sortBy(comparator);
        }
        query.constrain(predicate.extentType());
        if (predicate instanceof Db4oEnhancedFilter) {
            ((Db4oEnhancedFilter)((Object)predicate)).optimizeQuery(query);
            this.notifyListeners(predicate, PREOPTIMIZED, null);
            return query;
        }
        try {
            if (this.shouldOptimize()) {
                Object optimized = this._enhancer.optimize(query, predicate);
                this.notifyListeners(predicate, DYNOPTIMIZED, optimized);
                return query;
            }
        }
        catch (Exception optimizationFailure) {
            // empty catch block
        }
        query.constrain(new PredicateEvaluation(predicate));
        this.notifyListeners(predicate, UNOPTIMIZED, null);
        if (this.shouldOptimize() && (dp = ((ObjectContainerBase)this._container)._handlers.diagnosticProcessor()).enabled()) {
            dp.nativeQueryUnoptimized(predicate, null);
        }
        return query;
    }

    private boolean shouldOptimize() {
        return this._container.ext().configure().optimizeNativeQueries() && this._enhancer != null;
    }

    private void notifyListeners(Predicate predicate, String msg, Object optimized) {
        NQOptimizationInfo info = new NQOptimizationInfo(predicate, msg, optimized);
        Iterator4Impl iter = new Iterator4Impl(this._listeners);
        while (iter.moveNext()) {
            ((Db4oQueryExecutionListener)iter.current()).notifyQueryExecuted(info);
        }
    }

    private void loadQueryOptimizer() {
        block5: {
            Class clazz = ReflectPlatform.forName(OPTIMIZER_IMPL_NAME);
            DiagnosticProcessor dp = ((ObjectContainerBase)this._container)._handlers.diagnosticProcessor();
            if (clazz == null) {
                if (dp.enabled()) {
                    dp.nativeQueryOptimizerNotLoaded(1, null);
                }
                return;
            }
            try {
                Constructor constructor = clazz.getConstructor(Reflector.class);
                if (constructor == null) {
                    return;
                }
                this._enhancer = (Db4oNQOptimizer)constructor.newInstance(this._container.ext().reflector());
            }
            catch (Exception e) {
                if (!dp.enabled()) break block5;
                dp.nativeQueryOptimizerNotLoaded(2, e);
            }
        }
    }
}

