/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.foundation.Closure4;
import com.db4o.foundation.Visitable;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.CallbackInfoCollector;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.IdSlotChanges;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;
import com.db4o.internal.slots.SlotChangeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalIdSystemImpl
implements TransactionalIdSystem {
    private IdSlotChanges _slotChanges;
    private TransactionalIdSystemImpl _parentIdSystem;
    private final Closure4<IdSystem> _globalIdSystem;

    public TransactionalIdSystemImpl(Closure4<FreespaceManager> freespaceManager, Closure4<IdSystem> globalIdSystem, TransactionalIdSystemImpl parentIdSystem) {
        this._globalIdSystem = globalIdSystem;
        this._slotChanges = new IdSlotChanges(this, freespaceManager);
        this._parentIdSystem = parentIdSystem;
    }

    @Override
    public void collectCallBackInfo(final CallbackInfoCollector collector) {
        if (!this._slotChanges.isDirty()) {
            return;
        }
        this._slotChanges.traverseSlotChanges(new Visitor4<SlotChange>(){

            @Override
            public void visit(SlotChange slotChange) {
                int id = slotChange._key;
                if (slotChange.isDeleted()) {
                    if (!slotChange.isNew()) {
                        collector.deleted(id);
                    }
                } else if (slotChange.isNew()) {
                    collector.added(id);
                } else {
                    collector.updated(id);
                }
            }
        });
    }

    @Override
    public boolean isDirty() {
        return this._slotChanges.isDirty();
    }

    @Override
    public void commit(FreespaceCommitter freespaceCommitter) {
        Visitable<SlotChange> slotChangeVisitable = new Visitable<SlotChange>(){

            @Override
            public void accept(Visitor4<SlotChange> visitor) {
                TransactionalIdSystemImpl.this.traverseSlotChanges(visitor);
            }
        };
        freespaceCommitter.transactionalIdSystem(this);
        this.accumulateFreeSlots(freespaceCommitter, false);
        this.globalIdSystem().commit(slotChangeVisitable, freespaceCommitter);
    }

    @Override
    public void accumulateFreeSlots(FreespaceCommitter accumulator, boolean forFreespace) {
        this._slotChanges.accumulateFreeSlots(accumulator, forFreespace, this.isSystemIdSystem());
        if (this._parentIdSystem != null) {
            this._parentIdSystem.accumulateFreeSlots(accumulator, forFreespace);
        }
    }

    private boolean isSystemIdSystem() {
        return this._parentIdSystem == null;
    }

    public void completeInterruptedTransaction(int transactionId1, int transactionId2) {
        this.globalIdSystem().completeInterruptedTransaction(transactionId1, transactionId2);
    }

    @Override
    public Slot committedSlot(int id) {
        if (id == 0) {
            return null;
        }
        return this.globalIdSystem().committedSlot(id);
    }

    @Override
    public Slot currentSlot(int id) {
        Slot slot = this.modifiedSlot(id);
        if (slot != null) {
            return slot;
        }
        return this.committedSlot(id);
    }

    public Slot modifiedSlot(int id) {
        if (id == 0) {
            return null;
        }
        SlotChange change = this._slotChanges.findSlotChange(id);
        if (change != null && change.slotModified()) {
            return change.newSlot();
        }
        return this.modifiedSlotInParentIdSystem(id);
    }

    public final Slot modifiedSlotInParentIdSystem(int id) {
        if (this._parentIdSystem == null) {
            return null;
        }
        return this._parentIdSystem.modifiedSlot(id);
    }

    @Override
    public void rollback() {
        this._slotChanges.rollback();
    }

    @Override
    public void clear() {
        this._slotChanges.clear();
    }

    @Override
    public boolean isDeleted(int id) {
        return this._slotChanges.isDeleted(id);
    }

    @Override
    public void notifySlotUpdated(int id, Slot slot, SlotChangeFactory slotChangeFactory) {
        this._slotChanges.notifySlotUpdated(id, slot, slotChangeFactory);
    }

    private void traverseSlotChanges(Visitor4<SlotChange> visitor) {
        if (this._parentIdSystem != null) {
            this._parentIdSystem.traverseSlotChanges(visitor);
        }
        this._slotChanges.traverseSlotChanges(visitor);
    }

    @Override
    public int newId(SlotChangeFactory slotChangeFactory) {
        int id = this.acquireId();
        this._slotChanges.produceSlotChange(id, slotChangeFactory).notifySlotCreated(null);
        return id;
    }

    private int acquireId() {
        return this.globalIdSystem().newId();
    }

    @Override
    public int prefetchID() {
        int id = this.acquireId();
        this._slotChanges.addPrefetchedID(id);
        return id;
    }

    @Override
    public void prefetchedIDConsumed(int id) {
        this._slotChanges.prefetchedIDConsumed(id);
    }

    @Override
    public void notifySlotCreated(int id, Slot slot, SlotChangeFactory slotChangeFactory) {
        this._slotChanges.notifySlotCreated(id, slot, slotChangeFactory);
    }

    @Override
    public void notifySlotDeleted(int id, SlotChangeFactory slotChangeFactory) {
        this._slotChanges.notifySlotDeleted(id, slotChangeFactory);
    }

    private IdSystem globalIdSystem() {
        return this._globalIdSystem.run();
    }

    @Override
    public void close() {
        this._slotChanges.freePrefetchedIDs(this.globalIdSystem());
    }
}

