/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.ext.Db4oFatalException;
import com.db4o.foundation.Function4;
import com.db4o.internal.ByteArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialIdGenerator {
    private final int _minValidId;
    private final int _maxValidId;
    private int _idGenerator;
    private boolean _overflow;
    private int _lastIdGenerator;
    private final Function4<Integer, Integer> _findFreeId;

    public SequentialIdGenerator(Function4<Integer, Integer> findFreeId, int initialValue, int minValidId, int maxValidId) {
        this._findFreeId = findFreeId;
        this._minValidId = minValidId;
        this._maxValidId = maxValidId;
        this.initializeGenerator(initialValue);
    }

    public SequentialIdGenerator(Function4<Integer, Integer> findFreeId, int minValidId, int maxValidId) {
        this(findFreeId, minValidId - 1, minValidId, maxValidId);
    }

    public void read(ByteArrayBuffer buffer) {
        this.initializeGenerator(buffer.readInt());
    }

    private void initializeGenerator(int val) {
        if (val < 0) {
            this._overflow = true;
            this._idGenerator = -val;
        } else {
            this._idGenerator = val;
        }
        this._lastIdGenerator = this._idGenerator;
    }

    public void write(ByteArrayBuffer buffer) {
        buffer.writeInt(this.persistentGeneratorValue());
    }

    public int persistentGeneratorValue() {
        return this._overflow ? -this._idGenerator : this._idGenerator;
    }

    public int newId() {
        this.adjustIdGenerator(this._idGenerator);
        if (!this._overflow) {
            return this._idGenerator;
        }
        int id = this._findFreeId.apply(this._idGenerator);
        if (id > 0) {
            this.adjustIdGenerator(id - 1);
            return id;
        }
        id = this._findFreeId.apply(this._minValidId);
        if (id > 0) {
            this.adjustIdGenerator(id - 1);
            return id;
        }
        throw new Db4oFatalException("Out of IDs");
    }

    private void adjustIdGenerator(int id) {
        if (id == this._maxValidId) {
            this._idGenerator = this._minValidId;
            this._overflow = true;
            return;
        }
        this._idGenerator = id + 1;
    }

    public int marshalledLength() {
        return 4;
    }

    public boolean isDirty() {
        return this._idGenerator != this._lastIdGenerator;
    }

    public void setClean() {
        this._lastIdGenerator = this._idGenerator;
    }
}

