/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.DTrace;
import com.db4o.ext.InvalidIDException;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Pair;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Visitable;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.Indexable4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.PersistentIntegerArray;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeConfiguration;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.IdSlotMapping;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.ids.SequentialIdGenerator;
import com.db4o.internal.ids.StackableIdSystem;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;
import com.db4o.internal.slots.SlotChangeFactory;
import com.db4o.marshall.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeIdSystem
implements StackableIdSystem {
    private static final int BTREE_ID_INDEX = 0;
    private static final int ID_GENERATOR_INDEX = 1;
    private static final int CHILD_ID_INDEX = 2;
    private final LocalObjectContainer _container;
    private final StackableIdSystem _parentIdSystem;
    private final TransactionalIdSystem _transactionalIdSystem;
    private final SequentialIdGenerator _idGenerator;
    private BTree _bTree;
    private PersistentIntegerArray _persistentState;

    public BTreeIdSystem(LocalObjectContainer container, final StackableIdSystem parentIdSystem, int maxValidId) {
        this._container = container;
        this._parentIdSystem = parentIdSystem;
        this._transactionalIdSystem = container.newTransactionalIdSystem(null, new Closure4<IdSystem>(){

            @Override
            public IdSystem run() {
                return parentIdSystem;
            }
        });
        int persistentArrayId = parentIdSystem.childId();
        if (persistentArrayId == 0) {
            this.initializeNew();
        } else {
            this.initializeExisting(persistentArrayId);
        }
        this._idGenerator = new SequentialIdGenerator(new Function4<Integer, Integer>(){

            @Override
            public Integer apply(Integer start) {
                return BTreeIdSystem.this.findFreeId(start);
            }
        }, this.idGeneratorValue(), this._container.handlers().lowestValidId(), maxValidId);
    }

    public BTreeIdSystem(LocalObjectContainer container, StackableIdSystem idSystem) {
        this(container, idSystem, Integer.MAX_VALUE);
    }

    private void initializeExisting(int persistentArrayId) {
        this._persistentState = new PersistentIntegerArray(SlotChangeFactory.ID_SYSTEM, this._transactionalIdSystem, persistentArrayId);
        this._persistentState.read(this.transaction());
        this._bTree = new BTree(this.transaction(), this.bTreeConfiguration(), this.bTreeId(), new IdSlotMappingHandler());
    }

    private BTreeConfiguration bTreeConfiguration() {
        return new BTreeConfiguration(this._transactionalIdSystem, SlotChangeFactory.ID_SYSTEM, 64, false);
    }

    private int idGeneratorValue() {
        return this._persistentState.array()[1];
    }

    private void idGeneratorValue(int value) {
        this._persistentState.array()[1] = value;
    }

    private int bTreeId() {
        return this._persistentState.array()[0];
    }

    private void initializeNew() {
        this._bTree = new BTree(this.transaction(), this.bTreeConfiguration(), (Indexable4)new IdSlotMappingHandler());
        int idGeneratorValue = this._container.handlers().lowestValidId() - 1;
        this._persistentState = new PersistentIntegerArray(SlotChangeFactory.ID_SYSTEM, this._transactionalIdSystem, new int[]{this._bTree.getID(), idGeneratorValue, 0});
        this._persistentState.write(this.transaction());
        this._parentIdSystem.childId(this._persistentState.getID());
    }

    private int findFreeId(int start) {
        throw new NotImplementedException();
    }

    @Override
    public void close() {
    }

    @Override
    public Slot committedSlot(int id) {
        IdSlotMapping mapping = (IdSlotMapping)this._bTree.search(this.transaction(), new IdSlotMapping(id, 0, 0));
        if (mapping == null) {
            throw new InvalidIDException(id);
        }
        return mapping.slot();
    }

    @Override
    public void completeInterruptedTransaction(int transactionId1, int transactionId2) {
    }

    @Override
    public int newId() {
        int id = this._idGenerator.newId();
        this._bTree.add(this.transaction(), new IdSlotMapping(id, 0, 0));
        return id;
    }

    private Transaction transaction() {
        return this._container.systemTransaction();
    }

    @Override
    public void commit(Visitable<SlotChange> slotChanges, FreespaceCommitter freespaceCommitter) {
        this._container.freespaceManager().beginCommit();
        slotChanges.accept(new Visitor4<SlotChange>(){

            @Override
            public void visit(SlotChange slotChange) {
                if (!slotChange.slotModified()) {
                    return;
                }
                BTreeIdSystem.this._bTree.remove(BTreeIdSystem.this.transaction(), new IdSlotMapping(slotChange._key, 0, 0));
                if (slotChange.removeId()) {
                    return;
                }
                BTreeIdSystem.this._bTree.add(BTreeIdSystem.this.transaction(), new IdSlotMapping(slotChange._key, slotChange.newSlot()));
                if (DTrace.enabled) {
                    DTrace.SLOT_MAPPED.logLength((long)slotChange._key, slotChange.newSlot());
                }
            }
        });
        this._bTree.commit(this.transaction());
        this.idGeneratorValue(this._idGenerator.persistentGeneratorValue());
        if (this._idGenerator.isDirty()) {
            this._idGenerator.setClean();
            this._persistentState.setStateDirty();
        }
        if (this._persistentState.isDirty()) {
            this._persistentState.write(this.transaction());
        }
        this._container.freespaceManager().endCommit();
        this._transactionalIdSystem.commit(freespaceCommitter);
        this._transactionalIdSystem.clear();
    }

    @Override
    public void returnUnusedIds(Visitable<Integer> visitable) {
        visitable.accept(new Visitor4<Integer>(){

            @Override
            public void visit(Integer id) {
                BTreeIdSystem.this._bTree.remove(BTreeIdSystem.this.transaction(), new IdSlotMapping(id, 0, 0));
            }
        });
    }

    public TransactionalIdSystem freespaceIdSystem() {
        return this._transactionalIdSystem;
    }

    @Override
    public int childId() {
        return this._persistentState.array()[2];
    }

    @Override
    public void childId(int id) {
        this._persistentState.array()[2] = id;
        this._persistentState.setStateDirty();
    }

    public void traverseIds(Visitor4<IdSlotMapping> visitor) {
        this._bTree.traverseKeys(this._container.systemTransaction(), visitor);
    }

    @Override
    public void traverseOwnSlots(Procedure4<Pair<Integer, Slot>> block) {
        this._parentIdSystem.traverseOwnSlots(block);
        block.apply(this.ownSlotInfo(this._persistentState.getID()));
        block.apply(this.ownSlotInfo(this._bTree.getID()));
        Iterator4 nodeIds = this._bTree.allNodeIds(this._container.systemTransaction());
        while (nodeIds.moveNext()) {
            block.apply(this.ownSlotInfo((Integer)nodeIds.current()));
        }
    }

    private Pair<Integer, Slot> ownSlotInfo(int id) {
        return Pair.of(id, this._parentIdSystem.committedSlot(id));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdSlotMappingHandler
    implements Indexable4<IdSlotMapping> {
        @Override
        public void defragIndexEntry(DefragmentContextImpl context) {
            throw new NotImplementedException();
        }

        @Override
        public IdSlotMapping readIndexEntry(Context context, ByteArrayBuffer buffer) {
            return IdSlotMapping.read(buffer);
        }

        @Override
        public void writeIndexEntry(Context context, ByteArrayBuffer buffer, IdSlotMapping mapping) {
            mapping.write(buffer);
        }

        @Override
        public PreparedComparison prepareComparison(Context context, final IdSlotMapping sourceMapping) {
            return new PreparedComparison<IdSlotMapping>(){

                @Override
                public int compareTo(IdSlotMapping targetMapping) {
                    return sourceMapping._id == targetMapping._id ? 0 : (sourceMapping._id < targetMapping._id ? -1 : 1);
                }
            };
        }

        @Override
        public final int linkLength() {
            return 12;
        }
    }
}

