/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.TransactionContext;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectIdContext;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.typehandlers.QueryableTypeHandler;
import com.db4o.typehandlers.ValueTypeHandler;
import java.util.UUID;

public class UuidTypeHandler
implements ValueTypeHandler,
QueryableTypeHandler,
IndexableTypeHandler {
    private static final int LINK_LENGTH = 17;

    public void delete(DeleteContext context) throws Db4oIOException {
        this.skip(context);
    }

    public void defragment(DefragmentContext context) {
        this.skip(context);
    }

    public void write(WriteContext context, Object obj) {
        this.writeTo(context, (UUID)obj);
    }

    public Object readIndexEntry(Context context, ByteArrayBuffer reader) {
        return this.readFrom(reader);
    }

    public void writeIndexEntry(Context context, ByteArrayBuffer writer, Object obj) {
        this.writeTo(writer, (UUID)obj);
    }

    public void defragIndexEntry(DefragmentContextImpl context) {
        this.skip(context);
    }

    public PreparedComparison prepareComparison(Context context, Object obj) {
        final UUID value = obj instanceof TransactionContext ? (UUID)((TransactionContext)obj)._object : (UUID)obj;
        return new PreparedComparison<Object>(){

            @Override
            public int compareTo(Object other) {
                if (other == null) {
                    return value == null ? 0 : 1;
                }
                if (value == null) {
                    return -1;
                }
                return value.compareTo((UUID)other);
            }
        };
    }

    public int linkLength() {
        return 17;
    }

    public Object indexEntryToObject(Context context, Object indexEntry) {
        return indexEntry;
    }

    public Object readIndexEntryFromObjectSlot(MarshallerFamily mf, StatefulBuffer writer) throws CorruptionException, Db4oIOException {
        return this.readFrom(writer);
    }

    public Object readIndexEntry(ObjectIdContext context) throws CorruptionException, Db4oIOException {
        return this.readFrom(context);
    }

    public boolean descendsIntoMembers() {
        return false;
    }

    public Object read(ReadContext context) {
        return this.readFrom(context);
    }

    private UUID readFrom(ReadBuffer buffer) {
        if (buffer.readByte() == 0) {
            buffer.seek(buffer.offset() + 17 - 1);
            return null;
        }
        return new UUID(buffer.readLong(), buffer.readLong());
    }

    private void writeTo(WriteBuffer buffer, UUID uuid) {
        if (uuid == null) {
            for (int byteIdx = 0; byteIdx < 17; ++byteIdx) {
                buffer.writeByte((byte)0);
            }
            return;
        }
        buffer.writeByte((byte)1);
        buffer.writeLong(uuid.getMostSignificantBits());
        buffer.writeLong(uuid.getLeastSignificantBits());
    }

    private void skip(ReadBuffer buffer) {
        buffer.seek(buffer.offset() + this.linkLength());
    }
}

