/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.TransactionContext;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectIdContext;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.typehandlers.QueryableTypeHandler;
import com.db4o.typehandlers.ValueTypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteArrayRepresentableTypeHandler<T>
implements ValueTypeHandler,
VariableLengthTypeHandler,
QueryableTypeHandler,
IndexableTypeHandler {
    @Override
    public void defragment(DefragmentContext context) {
        this.skip(context);
    }

    @Override
    public void delete(DeleteContext context) throws Db4oIOException {
        this.skip(context);
    }

    @Override
    public Object read(ReadContext context) {
        return this.unmarshall(context);
    }

    @Override
    public void write(WriteContext context, Object obj) {
        byte[] data = this.toByteArray(obj);
        context.writeInt(data.length);
        context.writeBytes(data);
    }

    @Override
    public PreparedComparison<Object> prepareComparison(final Context context, Object obj) {
        final T value = obj instanceof TransactionContext ? this.valueFrom(((TransactionContext)obj)._object, context) : this.valueFrom(obj, context);
        return new PreparedComparison<Object>(){

            @Override
            public int compareTo(Object other) {
                if (other == null) {
                    return value == null ? 0 : 1;
                }
                if (value == null) {
                    return -1;
                }
                return ByteArrayRepresentableTypeHandler.this.compare(value, ByteArrayRepresentableTypeHandler.this.valueFrom(other, context));
            }
        };
    }

    @Override
    public boolean descendsIntoMembers() {
        return false;
    }

    @Override
    public void defragIndexEntry(DefragmentContextImpl context) {
        context.copyAddress();
        context.incrementIntSize();
    }

    @Override
    public int linkLength() {
        return 8;
    }

    public Object readIndexEntry(Context context, ByteArrayBuffer reader) {
        Slot s = new Slot(reader.readInt(), reader.readInt());
        if (this.isInvalidSlot(s)) {
            return null;
        }
        return s;
    }

    public void writeIndexEntry(Context context, ByteArrayBuffer writer, Object entry) {
        if (entry == null) {
            writer.writeInt(0);
            writer.writeInt(0);
            return;
        }
        if (entry instanceof StatefulBuffer) {
            StatefulBuffer entryAsWriter = (StatefulBuffer)entry;
            writer.writeInt(entryAsWriter.getAddress());
            writer.writeInt(entryAsWriter.length());
            return;
        }
        if (entry instanceof Slot) {
            Slot s = (Slot)entry;
            writer.writeInt(s.address());
            writer.writeInt(s.length());
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object indexEntryToObject(Context context, Object indexEntry) {
        if (indexEntry instanceof Slot) {
            Slot slot = (Slot)indexEntry;
            indexEntry = this.bufferFromSlot(context, slot);
        }
        return this.unmarshall((ReadBuffer)indexEntry);
    }

    @Override
    public Object readIndexEntry(ObjectIdContext context) throws CorruptionException, Db4oIOException {
        int payLoadOffSet = context.readInt();
        int length = context.readInt();
        if (payLoadOffSet == 0) {
            return null;
        }
        return ((StatefulBuffer)context.buffer()).readPayloadWriter(payLoadOffSet, length);
    }

    @Override
    public Object readIndexEntryFromObjectSlot(MarshallerFamily mf, StatefulBuffer buffer) throws CorruptionException, Db4oIOException {
        int payLoadOffSet = buffer.readInt();
        int length = buffer.readInt();
        if (payLoadOffSet == 0) {
            return null;
        }
        return buffer.readPayloadWriter(payLoadOffSet, length);
    }

    protected abstract T fromByteArray(byte[] var1);

    protected abstract byte[] toByteArray(T var1);

    protected abstract int compare(T var1, T var2);

    private ByteArrayBuffer bufferFromSlot(Context context, Slot slot) {
        return context.transaction().container().decryptedBufferByAddress(slot.address(), slot.length());
    }

    private T valueFrom(Object obj, Context context) {
        if (obj instanceof Slot) {
            obj = this.bufferFromSlot(context, (Slot)obj);
        }
        if (obj instanceof ReadBuffer) {
            ReadBuffer buffer = (ReadBuffer)obj;
            int offset = buffer.offset();
            buffer.seek(0);
            T number = this.unmarshall(buffer);
            buffer.seek(offset);
            return number;
        }
        return (T)obj;
    }

    private void skip(ReadBuffer context) {
        int numBytes = context.readInt();
        context.seek(context.offset() + numBytes);
    }

    private boolean isInvalidSlot(Slot slot) {
        return slot.isNull();
    }

    private T unmarshall(ReadBuffer buffer) {
        byte[] data = new byte[buffer.readInt()];
        buffer.readBytes(data);
        return this.fromByteArray(data);
    }
}

