/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeaderVariablePart;
import com.db4o.internal.fileheader.FileHeaderVariablePart1;
import com.db4o.internal.fileheader.NewFileHeaderBase;

public class FileHeader1
extends NewFileHeaderBase {
    private static final int TRANSACTION_POINTER_OFFSET = ACCESS_TIME_OFFSET + 8;
    private static final int BLOCKSIZE_OFFSET = TRANSACTION_POINTER_OFFSET + 8;
    public static final int HEADER_LENGTH = TRANSACTION_POINTER_OFFSET + 24;

    public int length() {
        return HEADER_LENGTH;
    }

    protected void read(LocalObjectContainer file, ByteArrayBuffer reader) {
        this.newTimerFileLock(file);
        this.oldEncryptionOff(file);
        this.checkThreadFileLock(file, reader);
        reader.seek(TRANSACTION_POINTER_OFFSET);
        file.systemData().transactionPointer1(reader.readInt());
        file.systemData().transactionPointer2(reader.readInt());
        reader.seek(BLOCKSIZE_OFFSET);
        file.blockSizeReadFromFile(reader.readInt());
        SystemData systemData = file.systemData();
        systemData.classCollectionID(reader.readInt());
        reader.readInt();
        this._variablePart = this.createVariablePart(file);
        int variablePartId = reader.readInt();
        this._variablePart.read(variablePartId, 0);
    }

    public void writeFixedPart(LocalObjectContainer file, boolean startFileLockingThread, boolean shuttingDown, StatefulBuffer writer, int blockSize) {
        throw new IllegalStateException();
    }

    public void writeTransactionPointer(Transaction systemTransaction, int transactionPointer) {
        throw new IllegalStateException();
    }

    protected NewFileHeaderBase createNew() {
        return new FileHeader1();
    }

    protected byte version() {
        return 1;
    }

    public FileHeaderVariablePart createVariablePart(LocalObjectContainer file) {
        return new FileHeaderVariablePart1(file);
    }
}

