/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.ext.Db4oIOException;
import com.db4o.ext.OldFormatException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeader1;
import com.db4o.internal.fileheader.FileHeader2;
import com.db4o.internal.fileheader.FileHeader3;
import com.db4o.internal.fileheader.NewFileHeaderBase;

public abstract class FileHeader {
    public static final int TRANSACTION_POINTER_LENGTH = 8;
    private static final FileHeader[] AVAILABLE_FILE_HEADERS = new FileHeader[]{new FileHeader1(), new FileHeader2(), new FileHeader3()};

    public static NewFileHeaderBase newCurrentFileHeader() {
        return new FileHeader3();
    }

    private static int readerLength() {
        int length = AVAILABLE_FILE_HEADERS[0].length();
        for (int i = 1; i < AVAILABLE_FILE_HEADERS.length; ++i) {
            length = Math.max(length, AVAILABLE_FILE_HEADERS[i].length());
        }
        return length;
    }

    public static FileHeader read(LocalObjectContainer file) throws OldFormatException {
        ByteArrayBuffer reader = FileHeader.prepareFileHeaderReader(file);
        FileHeader header = FileHeader.detectFileHeader(file, reader);
        if (header == null) {
            Exceptions4.throwRuntimeException(17, file.toString());
        } else {
            header.read(file, reader);
        }
        return header;
    }

    public FileHeader convert(LocalObjectContainer file) {
        FileHeader3 fileHeader = new FileHeader3();
        fileHeader.initNew(file);
        return fileHeader;
    }

    private static ByteArrayBuffer prepareFileHeaderReader(LocalObjectContainer file) {
        ByteArrayBuffer reader = new ByteArrayBuffer(FileHeader.readerLength());
        reader.read(file, 0, 0);
        return reader;
    }

    private static FileHeader detectFileHeader(LocalObjectContainer file, ByteArrayBuffer reader) {
        for (int i = 0; i < AVAILABLE_FILE_HEADERS.length; ++i) {
            reader.seek(0);
            FileHeader result = AVAILABLE_FILE_HEADERS[i].newOnSignatureMatch(file, reader);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public abstract void close() throws Db4oIOException;

    public abstract void initNew(LocalObjectContainer var1) throws Db4oIOException;

    public abstract void completeInterruptedTransaction(LocalObjectContainer var1);

    public abstract int length();

    protected abstract FileHeader newOnSignatureMatch(LocalObjectContainer var1, ByteArrayBuffer var2);

    protected long timeToWrite(long time, boolean shuttingDown) {
        return shuttingDown ? 0L : time;
    }

    protected abstract void read(LocalObjectContainer var1, ByteArrayBuffer var2);

    protected boolean signatureMatches(ByteArrayBuffer reader, byte[] signature, byte version) {
        for (int i = 0; i < signature.length; ++i) {
            if (reader.readByte() == signature[i]) continue;
            return false;
        }
        return reader.readByte() == version;
    }

    public abstract void writeFixedPart(LocalObjectContainer var1, boolean var2, boolean var3, StatefulBuffer var4, int var5);

    public abstract void writeTransactionPointer(Transaction var1, int var2);

    protected void writeTransactionPointer(Transaction systemTransaction, int transactionPointer, int address, int offset) {
        StatefulBuffer bytes = new StatefulBuffer(systemTransaction, address, 8);
        bytes.moveForward(offset);
        bytes.writeInt(transactionPointer);
        bytes.writeInt(transactionPointer);
        bytes.write();
    }

    public void writeVariablePart(LocalObjectContainer file) {
        this.writeVariablePart(file, false);
    }

    public abstract void writeVariablePart(LocalObjectContainer var1, boolean var2);

    public static boolean lockedByOtherSession(LocalObjectContainer container, long lastAccessTime) {
        return container.needsLockFileThread() && lastAccessTime != 0L;
    }

    public abstract void readIdentity(LocalObjectContainer var1);

    public abstract Runnable commit(boolean var1);
}

