/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.encoding;

import com.db4o.config.encoding.StringEncoding;
import com.db4o.internal.encoding.BuiltInStringEncoding;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.WriteBuffer;

public class DelegatingStringIO
extends LatinStringIO {
    private final StringEncoding _encoding;

    public DelegatingStringIO(StringEncoding encoding) {
        this._encoding = encoding;
    }

    private String decode(byte[] bytes, int start, int length) {
        return this._encoding.decode(bytes, start, length);
    }

    private byte[] encode(String str) {
        return this._encoding.encode(str);
    }

    public byte encodingByte() {
        if (this._encoding instanceof BuiltInStringEncoding) {
            return BuiltInStringEncoding.encodingByteForEncoding(this._encoding);
        }
        return 0;
    }

    public int length(String str) {
        return this.encode(str).length + 0 + 4;
    }

    public String read(ReadBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        return this.decode(bytes, 0, bytes.length);
    }

    public String read(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public int shortLength(String str) {
        return this.encode(str).length + 4;
    }

    public void write(WriteBuffer buffer, String str) {
        buffer.writeBytes(this.encode(str));
    }

    public byte[] write(String str) {
        return this.encode(str);
    }

    public void writeLengthAndString(WriteBuffer buffer, String str) {
        if (str == null) {
            buffer.writeInt(0);
            return;
        }
        byte[] bytes = this.encode(str);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
    }
}

