/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.encoding;

import com.db4o.config.encoding.StringEncoding;
import com.db4o.internal.encoding.DelegatingStringIO;
import com.db4o.internal.encoding.LatinStringEncoding;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.encoding.UTF8StringEncoding;
import com.db4o.internal.encoding.UnicodeStringEncoding;

public abstract class BuiltInStringEncoding
implements StringEncoding {
    private static final BuiltInStringEncoding[] ALL_ENCODINGS = new BuiltInStringEncoding[]{null, new LatinStringEncoding(), new UnicodeStringEncoding(), new UTF8StringEncoding()};

    public static byte encodingByteForEncoding(StringEncoding encoding) {
        for (int i = 1; i < ALL_ENCODINGS.length; ++i) {
            if (encoding.getClass() != ALL_ENCODINGS[i].getClass()) continue;
            return (byte)i;
        }
        return 0;
    }

    public static LatinStringIO stringIoForEncoding(byte encodingByte, StringEncoding encoding) {
        if (encodingByte < 0 || encodingByte > ALL_ENCODINGS.length) {
            throw new IllegalArgumentException();
        }
        if (encodingByte == 0) {
            if (encoding instanceof BuiltInStringEncoding) {
                System.out.println("Warning! Database was created with a custom string encoding but no custom string encoding is configured for this session.");
            }
            return new DelegatingStringIO(encoding);
        }
        BuiltInStringEncoding builtInEncoding = ALL_ENCODINGS[encodingByte];
        return builtInEncoding.createStringIo(encoding);
    }

    protected LatinStringIO createStringIo(StringEncoding encoding) {
        return new DelegatingStringIO(encoding);
    }
}

