/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.convert.conversions;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.FieldIndexException;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.VersionFieldMetadata;
import com.db4o.internal.convert.Conversion;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.handlers.HandlerVersion;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectIdContextImpl;

public class VersionNumberToCommitTimestamp_8_0
extends Conversion {
    public static final int VERSION = 12;
    private VersionFieldMetadata versionFieldMetadata;

    public void convert(ConversionStage.SystemUpStage stage) {
        LocalObjectContainer container = stage.file();
        if (!container.config().generateCommitTimestamps().definiteYes()) {
            return;
        }
        container.classCollection().writeAllClasses();
        this.buildCommitTimestampIndex(container);
        container.systemTransaction().commit();
    }

    private void buildCommitTimestampIndex(LocalObjectContainer container) {
        this.versionFieldMetadata = container.handlers().indexes()._version;
        ClassMetadataIterator i = container.classCollection().iterator();
        while (i.moveNext()) {
            ClassMetadata clazz = i.currentClass();
            if (!clazz.hasVersionField() || clazz.isStruct()) continue;
            this.rebuildIndexForClass(container, clazz);
        }
    }

    public boolean rebuildIndexForClass(LocalObjectContainer container, ClassMetadata classMetadata) {
        long[] ids = classMetadata.getIDs();
        for (int i = 0; i < ids.length; ++i) {
            this.rebuildIndexForObject(container, (int)ids[i]);
        }
        return ids.length > 0;
    }

    protected void rebuildIndexForObject(LocalObjectContainer container, int objectId) throws FieldIndexException {
        StatefulBuffer writer = container.readStatefulBufferById(container.systemTransaction(), objectId);
        if (writer != null) {
            this.rebuildIndexForWriter(container, writer, objectId);
        }
    }

    protected void rebuildIndexForWriter(LocalObjectContainer container, StatefulBuffer buffer, int objectId) {
        long version;
        ObjectHeader objectHeader = new ObjectHeader(container, (ReadWriteBuffer)buffer);
        ObjectIdContextImpl context = new ObjectIdContextImpl(container.systemTransaction(), buffer, objectHeader, objectId);
        ClassMetadata classMetadata = context.classMetadata();
        if (classMetadata.isStruct()) {
            return;
        }
        if (classMetadata.seekToField(container.systemTransaction(), buffer, this.versionFieldMetadata) != HandlerVersion.INVALID && (version = ((Long)this.versionFieldMetadata.read(context)).longValue()) != 0L) {
            LocalTransaction t = (LocalTransaction)container.systemTransaction();
            t.commitTimestampSupport().put(container.systemTransaction(), objectId, version);
        }
    }
}

