/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.internal.btree.SearchTarget;

public final class Searcher {
    private int _lower;
    private int _upper;
    private int _cursor;
    private int _cmp;
    private final SearchTarget _target;
    private final int _count;

    public Searcher(SearchTarget target, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        this._target = target;
        this._count = count;
        this._cmp = -1;
        if (count == 0) {
            this.complete();
            return;
        }
        this._cursor = -1;
        this._upper = count - 1;
        this.adjustCursor();
    }

    private void adjustBounds() {
        if (this._cmp > 0) {
            this._upper = this._cursor - 1;
            if (this._upper < this._lower) {
                this._upper = this._lower;
            }
            return;
        }
        if (this._cmp < 0) {
            this._lower = this._lower == this._cursor && this._lower < this._upper ? ++this._lower : this._cursor;
            return;
        }
        if (this._target == SearchTarget.ANY) {
            this._lower = this._cursor;
            this._upper = this._cursor;
        } else if (this._target == SearchTarget.HIGHEST) {
            this._lower = this._cursor;
        } else if (this._target == SearchTarget.LOWEST) {
            this._upper = this._cursor;
        } else {
            throw new IllegalStateException("Unknown target");
        }
    }

    private void adjustCursor() {
        int oldCursor = this._cursor;
        this._cursor = this._upper - this._lower <= 1 ? (this._target == SearchTarget.LOWEST && this._cmp == 0 ? this._lower : this._upper) : this._lower + (this._upper - this._lower) / 2;
        if (this._cursor == oldCursor) {
            this.complete();
        }
    }

    public boolean afterLast() {
        if (this._count == 0) {
            return false;
        }
        return this._cursor == this._count - 1 && this._cmp < 0;
    }

    public boolean beforeFirst() {
        return this._cursor == 0 && this._cmp > 0;
    }

    private void complete() {
        this._upper = -2;
    }

    public int count() {
        return this._count;
    }

    public int cursor() {
        return this._cursor;
    }

    public boolean foundMatch() {
        return this._cmp == 0;
    }

    public boolean incomplete() {
        return this._upper >= this._lower;
    }

    public void moveForward() {
        ++this._cursor;
    }

    public void resultIs(int cmp) {
        this._cmp = cmp;
        this.adjustBounds();
        this.adjustCursor();
    }

    public boolean isGreater() {
        return this._cmp < 0;
    }
}

