/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.foundation.Tree;
import com.db4o.internal.ArrayType;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.TreeInt;
import com.db4o.internal.delete.DeleteContextImpl;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.slots.Slot;

class WriteUpdateProcessor {
    private final LocalTransaction _transaction;
    private final int _id;
    private final ClassMetadata _clazz;
    private final ArrayType _typeInfo;
    private int _cascade = 0;

    public WriteUpdateProcessor(LocalTransaction transaction, int id, ClassMetadata clazz, ArrayType typeInfo) {
        this._transaction = transaction;
        this._id = id;
        this._clazz = clazz;
        this._typeInfo = typeInfo;
    }

    public void run() {
        this._transaction.checkSynchronization();
        if (DTrace.enabled) {
            DTrace.WRITE_UPDATE_ADJUST_INDEXES.log(this._id);
        }
        if (this.alreadyHandled()) {
            return;
        }
        Slot slot = this._transaction.idSystem().currentSlot(this._id);
        if (this.handledAsReAdd(slot)) {
            return;
        }
        if (this._clazz.canUpdateFast()) {
            return;
        }
        StatefulBuffer objectBytes = this.container().readStatefulBufferBySlot(this._transaction, this._id, slot);
        this.deleteMembers(objectBytes);
    }

    private LocalObjectContainer container() {
        return this._transaction.localContainer();
    }

    private void deleteMembers(StatefulBuffer objectBytes) {
        ObjectHeader oh = new ObjectHeader(this._clazz, (ReadWriteBuffer)objectBytes);
        DeleteInfo info = (DeleteInfo)TreeInt.find(this._transaction._delete, this._id);
        if (info != null && info._cascade > this._cascade) {
            this._cascade = info._cascade;
        }
        objectBytes.setCascadeDeletes(this._cascade);
        DeleteContextImpl context = new DeleteContextImpl(objectBytes, oh, this._clazz.classReflector(), null);
        this._clazz.deleteMembers(context, this._typeInfo, true);
    }

    private boolean handledAsReAdd(Slot slot) {
        if (!Slot.isNull(slot)) {
            return false;
        }
        this._clazz.addToIndex(this._transaction, this._id);
        return true;
    }

    private boolean alreadyHandled() {
        TreeInt newNode = new TreeInt(this._id);
        this._transaction._writtenUpdateAdjustedIndexes = Tree.add(this._transaction._writtenUpdateAdjustedIndexes, newNode);
        return !newNode.wasAddedToTree();
    }
}

