/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.ext.ObjectInfo;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.IdentitySet4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ArrayType;
import com.db4o.internal.CallbackInfoCollector;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.CommitTimestampSupport;
import com.db4o.internal.CommittedCallbackDispatcher;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.FrozenObjectInfo;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.LazyObjectReference;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectInfoCollectionImpl;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.WriteUpdateProcessor;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.references.ReferenceSystem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransaction
extends Transaction {
    private final IdentitySet4 _participants = new IdentitySet4();
    Tree _writtenUpdateAdjustedIndexes;
    protected final LocalObjectContainer _file;
    private final CommittedCallbackDispatcher _committedCallbackDispatcher;
    private final TransactionalIdSystem _idSystem;
    private CommitTimestampSupport _commitTimestampSupport = null;
    private long _timestamp;
    private List<Long> _concurrentReplicationTimestamps;

    public LocalTransaction(ObjectContainerBase container, Transaction parentTransaction, TransactionalIdSystem idSystem, ReferenceSystem referenceSystem) {
        super(container, parentTransaction, referenceSystem);
        this._file = (LocalObjectContainer)container;
        this._committedCallbackDispatcher = new CommittedCallbackDispatcher(){

            public boolean willDispatchCommitted() {
                return LocalTransaction.this.callbacks().caresAboutCommitted();
            }

            public void dispatchCommitted(CallbackObjectInfoCollections committedInfo) {
                LocalTransaction.this.callbacks().commitOnCompleted(LocalTransaction.this, committedInfo, false);
            }
        };
        this._idSystem = idSystem;
    }

    public Config4Impl config() {
        return this.container().config();
    }

    public LocalObjectContainer localContainer() {
        return this._file;
    }

    @Override
    public void commit() {
        this.commit(this._committedCallbackDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CommittedCallbackDispatcher dispatcher) {
        Object object = this.container().lock();
        synchronized (object) {
            this.commitListeners();
            this.dispatchCommittingCallback();
            if (!this.doCommittedCallbacks(dispatcher)) {
                this.commitImpl();
                this.commitClearAll();
            } else {
                Collection4 deleted = this.collectCommittedCallbackDeletedInfo();
                this.commitImpl();
                CallbackObjectInfoCollections committedInfo = this.collectCommittedCallbackInfo(deleted);
                this.commitClearAll();
                dispatcher.dispatchCommitted(CallbackObjectInfoCollections.EMTPY == committedInfo ? committedInfo : new CallbackObjectInfoCollections(committedInfo.added, committedInfo.updated, new ObjectInfoCollectionImpl(deleted)));
            }
        }
    }

    private void dispatchCommittingCallback() {
        if (this.doCommittingCallbacks()) {
            this.callbacks().commitOnStarted(this, this.collectCommittingCallbackInfo());
        }
    }

    private boolean doCommittedCallbacks(CommittedCallbackDispatcher dispatcher) {
        if (this.isSystemTransaction()) {
            return false;
        }
        return dispatcher.willDispatchCommitted();
    }

    private boolean doCommittingCallbacks() {
        if (this.isSystemTransaction()) {
            return false;
        }
        return this.callbacks().caresAboutCommitting();
    }

    public void enlist(TransactionParticipant participant) {
        if (null == participant) {
            throw new ArgumentNullException();
        }
        this.checkSynchronization();
        if (!this._participants.contains(participant)) {
            this._participants.add(participant);
        }
    }

    private void commitImpl() {
        if (DTrace.enabled) {
            DTrace.TRANS_COMMIT.logInfo("server == " + this.container().isServer() + ", systemtrans == " + this.isSystemTransaction());
        }
        this.commitClassMetadata();
        this.commitParticipants();
        this.container().writeDirtyClassMetadata();
        this.idSystem().commit(new FreespaceCommitter(this.localContainer().freespaceManager()));
    }

    private void commitListeners() {
        this.commitParentListeners();
        this.commitTransactionListeners();
    }

    private void commitParentListeners() {
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().commitListeners();
        }
    }

    private void commitParticipants() {
        if (this.parentLocalTransaction() != null) {
            this.parentLocalTransaction().commitParticipants();
        }
        Iterator4 iterator = this._participants.iterator();
        while (iterator.moveNext()) {
            ((TransactionParticipant)iterator.current()).commit(this);
        }
    }

    private void commitClassMetadata() {
        this.container().processPendingClassUpdates();
        this.container().writeDirtyClassMetadata();
        this.container().classCollection().write(this.container().systemTransaction());
    }

    private LocalTransaction parentLocalTransaction() {
        return (LocalTransaction)this._systemTransaction;
    }

    private void commitClearAll() {
        if (this._systemTransaction != null) {
            this.parentLocalTransaction().commitClearAll();
        }
        this.clearAll();
    }

    @Override
    protected void clear() {
        this.idSystem().clear();
        this.disposeParticipants();
        this._participants.clear();
    }

    private void disposeParticipants() {
        Iterator4 iterator = this._participants.valuesIterator();
        while (iterator.moveNext()) {
            ((TransactionParticipant)iterator.current()).dispose(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Object object = this.container().lock();
        synchronized (object) {
            this.rollbackParticipants();
            this.idSystem().rollback();
            this.rollBackTransactionListeners();
            this.clearAll();
        }
    }

    private void rollbackParticipants() {
        Iterator4 iterator = this._participants.valuesIterator();
        while (iterator.moveNext()) {
            ((TransactionParticipant)iterator.current()).rollback(this);
        }
    }

    public void flushFile() {
        if (DTrace.enabled) {
            DTrace.TRANS_FLUSH.log();
        }
        this._file.syncFiles();
    }

    @Override
    public void processDeletes() {
        if (this._delete == null) {
            this._writtenUpdateAdjustedIndexes = null;
            return;
        }
        while (this._delete != null) {
            Tree delete = this._delete;
            this._delete = null;
            delete.traverse(new Visitor4(){

                public void visit(Object a_object) {
                    DeleteInfo info = (DeleteInfo)a_object;
                    if (LocalTransaction.this.localContainer().isDeleted(LocalTransaction.this, info._key)) {
                        return;
                    }
                    Object obj = null;
                    if (info._reference != null) {
                        obj = info._reference.getObject();
                    }
                    if (obj == null || info._reference.getID() < 0) {
                        HardObjectReference hardRef = LocalTransaction.this.container().getHardObjectReferenceById(LocalTransaction.this, info._key);
                        if (hardRef == HardObjectReference.INVALID) {
                            return;
                        }
                        info._reference = hardRef._reference;
                        info._reference.flagForDelete(LocalTransaction.this.container().topLevelCallId());
                        obj = info._reference.getObject();
                    }
                    LocalTransaction.this.container().delete3(LocalTransaction.this, info._reference, obj, info._cascade, false);
                }
            });
        }
        this._writtenUpdateAdjustedIndexes = null;
    }

    @Override
    public void writeUpdateAdjustIndexes(int id, ClassMetadata clazz, ArrayType typeInfo) {
        new WriteUpdateProcessor(this, id, clazz, typeInfo).run();
    }

    private Callbacks callbacks() {
        return this.container().callbacks();
    }

    private Collection4 collectCommittedCallbackDeletedInfo() {
        final Collection4 deleted = new Collection4();
        this.collectCallBackInfo(new CallbackInfoCollector(){

            public void deleted(int id) {
                ObjectInfo ref = LocalTransaction.this.frozenReferenceFor(id);
                if (ref != null) {
                    deleted.add(ref);
                }
            }

            public void updated(int id) {
            }

            public void added(int id) {
            }
        });
        return deleted;
    }

    private CallbackObjectInfoCollections collectCommittedCallbackInfo(Collection4 deleted) {
        if (!this.idSystem().isDirty()) {
            return CallbackObjectInfoCollections.EMTPY;
        }
        final Collection4 added = new Collection4();
        final Collection4 updated = new Collection4();
        this.collectCallBackInfo(new CallbackInfoCollector(){

            public void added(int id) {
                added.add(LocalTransaction.this.lazyReferenceFor(id));
            }

            public void updated(int id) {
                updated.add(LocalTransaction.this.lazyReferenceFor(id));
            }

            public void deleted(int id) {
            }
        });
        return this.newCallbackObjectInfoCollections(added, updated, deleted);
    }

    private CallbackObjectInfoCollections collectCommittingCallbackInfo() {
        if (!this.idSystem().isDirty()) {
            return CallbackObjectInfoCollections.EMTPY;
        }
        final Collection4 added = new Collection4();
        final Collection4 deleted = new Collection4();
        final Collection4 updated = new Collection4();
        this.collectCallBackInfo(new CallbackInfoCollector(){

            public void added(int id) {
                added.add(LocalTransaction.this.lazyReferenceFor(id));
            }

            public void updated(int id) {
                updated.add(LocalTransaction.this.lazyReferenceFor(id));
            }

            public void deleted(int id) {
                ObjectInfo ref = LocalTransaction.this.frozenReferenceFor(id);
                if (ref != null) {
                    deleted.add(ref);
                }
            }
        });
        return this.newCallbackObjectInfoCollections(added, updated, deleted);
    }

    private CallbackObjectInfoCollections newCallbackObjectInfoCollections(Collection4 added, Collection4 updated, Collection4 deleted) {
        return new CallbackObjectInfoCollections(new ObjectInfoCollectionImpl(added), new ObjectInfoCollectionImpl(updated), new ObjectInfoCollectionImpl(deleted));
    }

    private void collectCallBackInfo(CallbackInfoCollector collector) {
        this.idSystem().collectCallBackInfo(collector);
    }

    @Override
    public TransactionalIdSystem idSystem() {
        return this._idSystem;
    }

    public ObjectInfo frozenReferenceFor(int id) {
        ObjectReference ref = this.referenceForId(id);
        if (ref != null) {
            if (this.isStruct(ref)) {
                return null;
            }
            return new FrozenObjectInfo(this, ref, true);
        }
        ref = this.container().peekReference(this.systemTransaction(), id, new FixedActivationDepth(0), true);
        if (ref == null || ref.getObject() == null || this.isStruct(ref)) {
            return null;
        }
        return new FrozenObjectInfo(this.systemTransaction(), ref, true);
    }

    private boolean isStruct(ObjectReference ref) {
        return ref.classMetadata().isStruct();
    }

    public LazyObjectReference lazyReferenceFor(int id) {
        return new LazyObjectReference(this, id);
    }

    @Override
    public long versionForId(int id) {
        return this.commitTimestampSupport().versionForId(id);
    }

    public CommitTimestampSupport commitTimestampSupport() {
        if (!this.isSystemTransaction()) {
            throw new IllegalStateException();
        }
        if (this._commitTimestampSupport == null) {
            this._commitTimestampSupport = new CommitTimestampSupport(this.localContainer());
        }
        return this._commitTimestampSupport;
    }

    @Override
    public long generateTransactionTimestamp(long forcedTimeStamp) {
        this._timestamp = forcedTimeStamp > 0L ? forcedTimeStamp : this.localContainer().generateTimeStampId();
        return this._timestamp;
    }

    @Override
    public void useDefaultTransactionTimestamp() {
        this._timestamp = 0L;
        this._concurrentReplicationTimestamps = null;
    }

    public long timestamp() {
        return this._timestamp;
    }

    public void notifyAboutOtherReplicationCommit(long replicationVersion, List<Long> concurrentTimestamps) {
        if (this.timestamp() == 0L) {
            return;
        }
        if (this._concurrentReplicationTimestamps == null) {
            this._concurrentReplicationTimestamps = new ArrayList<Long>();
        }
        this._concurrentReplicationTimestamps.add(replicationVersion);
        concurrentTimestamps.add(this.timestamp());
    }

    public List<Long> concurrentReplicationTimestamps() {
        if (this._concurrentReplicationTimestamps != null) {
            return this._concurrentReplicationTimestamps;
        }
        return new ArrayList<Long>();
    }

    @Override
    public void postOpen() {
        super.postOpen();
        if (this.isSystemTransaction()) {
            this.commitTimestampSupport().ensureInitialized();
        }
    }
}

