/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.TernaryBool;
import com.db4o.internal.JDK;
import com.db4o.internal.JDKFactory;
import com.db4o.internal.JDK_1_3;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReflectException;
import com.db4o.internal.Reflection4;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.core.ReflectConstructor;
import com.db4o.reflect.jdk.JdkConstructor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;

class JDK_1_4
extends JDK_1_3 {
    private Hashtable fileLocks;
    private Object _reflectionFactory;
    private Constructor _objectConstructor;
    private Method _factoryMethod;

    JDK_1_4() {
    }

    synchronized void lockFile(String path, Object file) {
        String canonicalPath;
        try {
            canonicalPath = new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
        if (this.fileLocks == null) {
            this.fileLocks = new Hashtable();
        }
        if (this.fileLocks.containsKey(canonicalPath)) {
            throw new DatabaseFileLockedException(canonicalPath);
        }
        Object lock = null;
        Object channel = Reflection4.invoke(file, "getChannel");
        try {
            lock = Reflection4.invoke(channel, "tryLock");
        }
        catch (ReflectException rex) {
            throw new DatabaseFileLockedException(canonicalPath, rex);
        }
        if (lock == null) {
            throw new DatabaseFileLockedException(canonicalPath);
        }
        this.fileLocks.put(canonicalPath, lock);
    }

    synchronized void unlockFile(String path, Object file) {
        if (this.fileLocks == null) {
            return;
        }
        Object fl = this.fileLocks.get(path);
        if (fl == null) {
            return;
        }
        Reflection4.invoke("java.nio.channels.FileLock", "release", null, null, fl);
        this.fileLocks.remove(path);
    }

    public ReflectConstructor serializableConstructor(Reflector reflector, Class clazz) {
        if (this._reflectionFactory == null && !this.initSerializableConstructor()) {
            Platform4.callConstructorCheck = TernaryBool.YES;
            return null;
        }
        Constructor serializableConstructor = (Constructor)Reflection4.invoke(new Object[]{clazz, this._objectConstructor}, this._reflectionFactory, this._factoryMethod);
        if (null == serializableConstructor) {
            return null;
        }
        return new JdkConstructor(reflector, serializableConstructor);
    }

    private boolean initSerializableConstructor() {
        try {
            this._reflectionFactory = Reflection4.invoke("sun.reflect.ReflectionFactory", "getReflectionFactory", null, null, null);
            this._factoryMethod = Reflection4.getMethod("sun.reflect.ReflectionFactory", "newConstructorForSerialization", new Class[]{Class.class, Constructor.class});
            if (this._factoryMethod == null) {
                return false;
            }
        }
        catch (ReflectException e) {
            return false;
        }
        try {
            this._objectConstructor = Object.class.getDeclaredConstructor(null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int ver() {
        return 4;
    }

    public static final class Factory
    implements JDKFactory {
        public JDK tryToCreate() {
            if (!JDK.classIsAvailable("java.nio.channels.FileLock")) {
                return null;
            }
            return new JDK_1_4();
        }
    }
}

