/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

public class TimeStampIdGenerator {
    public static final int BITS_RESERVED_FOR_COUNTER = 15;
    public static final int COUNTER_LIMIT = 64;
    private long _counter;
    private long _lastTime;

    public static long idToMilliseconds(long id) {
        return id >> 15;
    }

    public static long millisecondsToId(long milliseconds) {
        return milliseconds << 15;
    }

    public TimeStampIdGenerator(long minimumNext) {
        this.internalSetMinimumNext(minimumNext);
    }

    public TimeStampIdGenerator() {
        this(0L);
    }

    public long generate() {
        long t = this.now();
        if (t > this._lastTime) {
            this._lastTime = t;
            this._counter = 0L;
            return TimeStampIdGenerator.millisecondsToId(t);
        }
        this.updateTimeOnCounterLimitOverflow();
        ++this._counter;
        this.updateTimeOnCounterLimitOverflow();
        return this.last();
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    private final void updateTimeOnCounterLimitOverflow() {
        if (this._counter < 64L) {
            return;
        }
        long timeIncrement = this._counter / 64L;
        this._lastTime += timeIncrement;
        this._counter -= timeIncrement * 64L;
    }

    public long last() {
        return TimeStampIdGenerator.millisecondsToId(this._lastTime) + this._counter;
    }

    public boolean setMinimumNext(long newMinimum) {
        if (newMinimum <= this.last()) {
            return false;
        }
        this.internalSetMinimumNext(newMinimum);
        return true;
    }

    private void internalSetMinimumNext(long newNext) {
        this._lastTime = TimeStampIdGenerator.idToMilliseconds(newNext);
        long timePart = TimeStampIdGenerator.millisecondsToId(this._lastTime);
        this._counter = newNext - timePart;
        this.updateTimeOnCounterLimitOverflow();
    }
}

