/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

public class CRC32 {
    private static int[] crcTable;

    private static void buildCRCTable() {
        int CRC32_POLYNOMIAL = -306674912;
        crcTable = new int[256];
        for (int i = 0; i <= 255; ++i) {
            int crc = i;
            for (int j = 8; j > 0; --j) {
                if ((crc & 1) == 1) {
                    crc = crc >>> 1 ^ 0xEDB88320;
                    continue;
                }
                crc >>>= 1;
            }
            CRC32.crcTable[i] = crc;
        }
    }

    public static long checkSum(byte[] buffer, int start, int count) {
        int i = start;
        int crc = -1;
        while (count-- != 0) {
            int temp1 = crc >>> 8;
            int temp2 = crcTable[(crc ^ buffer[i++]) & 0xFF];
            crc = temp1 ^ temp2;
        }
        return (long)(~crc) & 0xFFFFFFFFL;
    }

    static {
        CRC32.buildCRCTable();
    }
}

