/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.filestats;

import com.db4o.filestats.FileUsageStatsUtil;

public class ClassUsageStats {
    private final String _className;
    private final long _slotUsage;
    private final long _classIndexUsage;
    private final long _fieldIndexUsage;
    private final long _miscUsage;

    ClassUsageStats(String className, long slotSpace, long classIndexUsage, long fieldIndexUsage, long miscUsage) {
        this._className = className;
        this._slotUsage = slotSpace;
        this._classIndexUsage = classIndexUsage;
        this._fieldIndexUsage = fieldIndexUsage;
        this._miscUsage = miscUsage;
    }

    public String className() {
        return this._className;
    }

    public long slotUsage() {
        return this._slotUsage;
    }

    public long classIndexUsage() {
        return this._classIndexUsage;
    }

    public long fieldIndexUsage() {
        return this._fieldIndexUsage;
    }

    public long miscUsage() {
        return this._miscUsage;
    }

    public long totalUsage() {
        return this._slotUsage + this._classIndexUsage + this._fieldIndexUsage + this._miscUsage;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.toString(str);
        return str.toString();
    }

    void toString(StringBuffer str) {
        str.append(this.className()).append("\n");
        str.append(FileUsageStatsUtil.formatLine("Slots", this.slotUsage()));
        str.append(FileUsageStatsUtil.formatLine("Class index", this.classIndexUsage()));
        str.append(FileUsageStatsUtil.formatLine("Field indices", this.fieldIndexUsage()));
        if (this.miscUsage() > 0L) {
            str.append(FileUsageStatsUtil.formatLine("Misc", this.miscUsage()));
        }
        str.append(FileUsageStatsUtil.formatLine("Total", this.totalUsage()));
    }
}

