/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.defragment.AbstractIdMapping;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitable;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Indexable4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.ids.BTreeIdSystem;
import com.db4o.internal.ids.IdSlotMapping;
import com.db4o.internal.mapping.MappedIDPair;
import com.db4o.internal.mapping.MappedIDPairHandler;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseIdMapping
extends AbstractIdMapping {
    private String _fileName;
    private LocalObjectContainer _mappingDb;
    private BTree _idTree;
    private BTree _slotTree;
    private MappedIDPair _cache = new MappedIDPair(0, 0);
    private BTreeSpec _treeSpec = null;
    private int _commitFrequency = 0;
    private int _idInsertCount = 0;
    private int _slotInsertCount = 0;

    public DatabaseIdMapping(String fileName) {
        this(fileName, null, 0);
    }

    public DatabaseIdMapping(String fileName, int nodeSize, int commitFrequency) {
        this(fileName, new BTreeSpec(nodeSize), commitFrequency);
    }

    private DatabaseIdMapping(String fileName, BTreeSpec treeSpec, int commitFrequency) {
        this._fileName = fileName;
        this._treeSpec = treeSpec;
        this._commitFrequency = commitFrequency;
    }

    @Override
    public int mappedId(int oldID) {
        if (this._cache.orig() == oldID) {
            return this._cache.mapped();
        }
        int classID = this.mappedClassID(oldID);
        if (classID != 0) {
            return classID;
        }
        BTreeRange range = this._idTree.searchRange(this.trans(), new MappedIDPair(oldID, 0));
        Iterator4 pointers = range.pointers();
        if (pointers.moveNext()) {
            BTreePointer pointer = (BTreePointer)pointers.current();
            this._cache = (MappedIDPair)pointer.key();
            return this._cache.mapped();
        }
        return 0;
    }

    @Override
    protected void mapNonClassIDs(int origID, int mappedID) {
        this._cache = new MappedIDPair(origID, mappedID);
        this._idTree.add(this.trans(), this._cache);
        if (this._commitFrequency > 0) {
            ++this._idInsertCount;
            if (this._commitFrequency == this._idInsertCount) {
                this._idTree.commit(this.trans());
                this._idInsertCount = 0;
            }
        }
    }

    @Override
    public void open() throws IOException {
        this._mappingDb = DefragmentServicesImpl.freshTempFile(this._fileName, 1);
        this._idTree = this._treeSpec == null ? new BTree(this.trans(), 0, (Indexable4)new MappedIDPairHandler()) : new BTree(this.trans(), 0, new MappedIDPairHandler(), this._treeSpec.nodeSize());
        this._slotTree = this._treeSpec == null ? new BTree(this.trans(), 0, (Indexable4)new BTreeIdSystem.IdSlotMappingHandler()) : new BTree(this.trans(), 0, new BTreeIdSystem.IdSlotMappingHandler(), this._treeSpec.nodeSize());
    }

    @Override
    public void close() {
        this._mappingDb.close();
    }

    private Transaction trans() {
        return this._mappingDb.systemTransaction();
    }

    @Override
    public void mapId(int id, Slot slot) {
        this._slotTree.add(this.trans(), new IdSlotMapping(id, slot.address(), slot.length()));
        if (this._commitFrequency > 0) {
            ++this._slotInsertCount;
            if (this._commitFrequency == this._slotInsertCount) {
                this._slotTree.commit(this.trans());
                this._slotInsertCount = 0;
            }
        }
    }

    @Override
    public Visitable<SlotChange> slotChanges() {
        return new Visitable<SlotChange>(){

            @Override
            public void accept(final Visitor4<SlotChange> outSideVisitor) {
                DatabaseIdMapping.this._slotTree.traverseKeys(DatabaseIdMapping.this.trans(), new Visitor4<IdSlotMapping>(){

                    @Override
                    public void visit(IdSlotMapping idSlotMapping) {
                        SlotChange slotChange = new SlotChange(idSlotMapping._id);
                        slotChange.notifySlotCreated(idSlotMapping.slot());
                        outSideVisitor.visit(slotChange);
                    }
                });
            }
        };
    }

    @Override
    public int addressForId(int id) {
        BTreeRange range = this._slotTree.searchRange(this.trans(), new IdSlotMapping(id, 0, 0));
        Iterator4 pointers = range.pointers();
        if (pointers.moveNext()) {
            BTreePointer pointer = (BTreePointer)pointers.current();
            return ((IdSlotMapping)pointer.key())._address;
        }
        return 0;
    }

    @Override
    public void commit() {
        this._mappingDb.commit();
    }

    private static class BTreeSpec {
        private int _nodeSize;

        public BTreeSpec(int nodeSize) {
            this._nodeSize = nodeSize;
        }

        public int nodeSize() {
            return this._nodeSize;
        }
    }
}

