/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.cs.monitoring.NetworkingMBean;
import com.db4o.monitoring.MBeanRegistrationSupport;
import com.db4o.monitoring.internal.TimedReading;
import javax.management.JMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Networking
extends MBeanRegistrationSupport
implements NetworkingMBean {
    private TimedReading _bytesSent;
    private TimedReading _bytesReceived;
    private TimedReading _messagesSent;

    public Networking(ObjectContainer db, Class<?> type) throws JMException {
        super(db, type);
    }

    @Override
    public double getBytesSentPerSecond() {
        return this.bytesSent().read();
    }

    @Override
    public double getBytesReceivedPerSecond() {
        return this.bytesReceived().read();
    }

    @Override
    public double getMessagesSentPerSecond() {
        return this.messagesSent().read();
    }

    public void notifyWrite(int count) {
        this.bytesSent().incrementBy(count);
        this.messagesSent().incrementBy(1);
    }

    public void notifyRead(int count) {
        this.bytesReceived().incrementBy(count);
    }

    private TimedReading messagesSent() {
        if (null == this._messagesSent) {
            this._messagesSent = TimedReading.newPerSecond();
        }
        return this._messagesSent;
    }

    private TimedReading bytesReceived() {
        if (null == this._bytesReceived) {
            this._bytesReceived = TimedReading.newPerSecond();
        }
        return this._bytesReceived;
    }

    private TimedReading bytesSent() {
        if (null == this._bytesSent) {
            this._bytesSent = TimedReading.newPerSecond();
        }
        return this._bytesSent;
    }

    public String toString() {
        return this.objectName().toString();
    }

    @Override
    public void resetCounters() {
        this.reset(this._bytesSent);
        this.reset(this._bytesReceived);
        this.reset(this._messagesSent);
    }

    private void reset(TimedReading counter) {
        if (null != counter) {
            counter.resetCount();
        }
    }
}

