/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.config;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.Configuration;
import com.db4o.config.LegacyClientServerFactory;
import com.db4o.cs.config.ClientConfiguration;
import com.db4o.cs.config.ServerConfiguration;
import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.cs.internal.ObjectServerImpl;
import com.db4o.cs.internal.Socket4Adapter;
import com.db4o.cs.internal.config.Db4oClientServerLegacyConfigurationBridge;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.ext.InvalidPasswordException;
import com.db4o.ext.OldFormatException;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.LocalObjectContainer;

public class LegacyClientServerFactoryImpl
implements LegacyClientServerFactory {
    public ObjectContainer openClient(Configuration config, String hostName, int port, String user, String password) throws Db4oIOException, OldFormatException, InvalidPasswordException {
        if (user == null || password == null) {
            throw new InvalidPasswordException();
        }
        Config4Impl.assertIsNotTainted(config);
        ClientConfiguration clientConfig = Db4oClientServerLegacyConfigurationBridge.asClientConfiguration(config);
        Socket4Adapter networkSocket = new Socket4Adapter(clientConfig.networking().socketFactory(), hostName, port);
        return new ClientObjectContainer(clientConfig, networkSocket, user, password, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectServer openServer(Configuration config, String databaseFileName, int port) throws Db4oIOException, IncompatibleFileFormatException, OldFormatException, DatabaseFileLockedException, DatabaseReadOnlyException {
        LocalObjectContainer container = (LocalObjectContainer)Db4o.openFile(config, databaseFileName);
        if (container == null) {
            return null;
        }
        ServerConfiguration serverConfig = Db4oClientServerLegacyConfigurationBridge.asServerConfiguration(config);
        Object object = container.lock();
        synchronized (object) {
            return new ObjectServerImpl(container, serverConfig, port);
        }
    }
}

