/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.cs.internal.PrefetchingStrategy;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Pair;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMessagePrefetchingStrategy
implements PrefetchingStrategy {
    public static final PrefetchingStrategy INSTANCE = new SingleMessagePrefetchingStrategy();

    private SingleMessagePrefetchingStrategy() {
    }

    @Override
    public int prefetchObjects(ClientObjectContainer container, Transaction trans, IntIterator4 ids, Object[] prefetched, int prefetchCount) {
        int count = 0;
        ArrayList<Pair<Integer, Integer>> idsToGet = new ArrayList<Pair<Integer, Integer>>();
        while (count < prefetchCount && ids.moveNext()) {
            int id = ids.currentInt();
            if (id <= 0) continue;
            Object obj = trans.objectForIdFromCache(id);
            if (obj != null) {
                prefetched[count] = obj;
            } else {
                idsToGet.add(Pair.of(id, count));
            }
            ++count;
        }
        if (idsToGet.size() > 0) {
            ByteArrayBuffer[] buffers = container.readObjectSlots(trans, this.idArrayFor(idsToGet));
            for (int i = 0; i < buffers.length; ++i) {
                Pair pair = (Pair)idsToGet.get(i);
                int id = (Integer)pair.first;
                int position = (Integer)pair.second;
                Object obj = trans.objectForIdFromCache(id);
                prefetched[position] = obj != null ? obj : new ObjectReference(id).readPrefetch(trans, buffers[i], 1);
            }
        }
        return count;
    }

    private int[] idArrayFor(List<Pair<Integer, Integer>> idsToGet) {
        int[] idArray = new int[idsToGet.size()];
        for (int i = 0; i < idArray.length; ++i) {
            idArray[i] = (Integer)idsToGet.get((int)i).first;
        }
        return idArray;
    }
}

