/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.internal.BroadcastFilter;
import com.db4o.cs.internal.ObjectServerImpl;
import com.db4o.cs.internal.ServerMessageDispatcher;
import com.db4o.cs.internal.messages.MCommittedInfo;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.BlockingQueueStoppedException;

public class CommittedCallbacksDispatcher
implements Runnable {
    private boolean _stopped;
    private final BlockingQueue _committedInfosQueue;
    private final ObjectServerImpl _server;

    public CommittedCallbacksDispatcher(ObjectServerImpl server, BlockingQueue committedInfosQueue) {
        this._server = server;
        this._committedInfosQueue = committedInfosQueue;
    }

    public void run() {
        this.setThreadName();
        this.messageLoop();
    }

    private void messageLoop() {
        while (!this._stopped) {
            MCommittedInfo committedInfos;
            try {
                committedInfos = (MCommittedInfo)this._committedInfosQueue.next();
            }
            catch (BlockingQueueStoppedException e) {
                break;
            }
            this._server.broadcastMsg(committedInfos, new BroadcastFilter(){

                public boolean accept(ServerMessageDispatcher dispatcher) {
                    return dispatcher.caresAboutCommitted();
                }
            });
        }
    }

    private void setThreadName() {
        Thread.currentThread().setName("committed callback thread");
    }

    public void stop() {
        this._committedInfosQueue.stop();
        this._stopped = true;
    }
}

